require "ZomboLewd/ZomboLewdConfig"

ZomboLewdConfig.Modules.SpawnZombie = function(worldobjects, player)
    DebugLog.log("[ZomboLewd] /SpawnZombie/")

    -- Identify the first available world object
	local firstObject
	for _,o in ipairs(worldobjects) do
        if not firstObject then 
            firstObject = o 
        end
	end

    -- Abort if no spawn point is found
    if not firstObject then
        DebugLog.log("Warning: No valid world object found. Aborting spawn.")
        return
    end

    -- Determine spawn coordinates
    local spawnX = firstObject:getX()
    local spawnY = firstObject:getY()
    local spawnZ = player:getZ()

    -- Create a survivor descriptor with opposite gender to the player
    local descriptor = SurvivorFactory.CreateSurvivor()
    descriptor:setFemale(not player:isFemale())

    -- Summon the zombie and apply the descriptor’s gender
    print("Summoning zombie at:", spawnX, spawnY, spawnZ)
    local zombie = createZombie(spawnX, spawnY, spawnZ, descriptor, 0, player:getDir())
    zombie:setFemale(not player:isFemale())
end