require "ZomboLewd/ZomboLewdConfig"

local function Lerp(x, min1, max1, min2, max2)
	return min2 + ((x - min1) / (max1 - min1)) * (max2 - min2)
end

local function prepare_brain(zombie)		
		local id = zombie:getPersistentOutfitID()
		DebugLog.log(string.format("[ZomboLewd] /prepare_brain/ for id %d", id))	
		local brain = {}
	
		-- auto-generated properties 
		brain.id = id
		brain.inVehicle = false
		brain.fullname = SurvivorFactory.getRandomForename(not zombie:isFemale()) .. " " .. SurvivorFactory.getRandomSurname()
		brain.voice = 1
	
		brain.born = getGameTime():getWorldAgeHours()
		brain.bornCoords = {}
		brain.bornCoords.x = zombie:getX()
		brain.bornCoords.y = zombie:getY()
		brain.bornCoords.z = zombie:getZ()
	
		brain.stationary = false
		brain.sleeping = false
		brain.aiming = false
		brain.moving = false
		brain.endurance = 1.00
		brain.speech = 0.00
		brain.sound = 0.00
		brain.infection = 0
	
		-- properties taken from bandit custom profile
		brain.female = zombie:isFemale()
		brain.skin = 1
		brain.hairType = 1
		brain.hairColor = 1
		brain.beardType = 1
		brain.eatBody = false
	
		local health = 5
		brain.health = Lerp(health, 1, 9, 1, 2.6)
	
		local accuracyBoost = 5
		brain.accuracyBoost = Lerp(accuracyBoost, 1, 9, -8, 8)
	
		local enduranceBoost = 5
		brain.enduranceBoost = Lerp(enduranceBoost, 1, 9, 0.25, 1.75)
	
		local strengthBoost = 5
		brain.strengthBoost = Lerp(strengthBoost, 1, 9, 0.25, 1.75)
	
		brain.exp = {0, 0, 0}
	
		brain.weapons = {}
		brain.weapons.melee = "Base.BareHands"
		brain.weapons.primary = {["bulletsLeft"] = 0, ["magCount"] = 0}
		brain.weapons.secondary = {["bulletsLeft"] = 0, ["magCount"] = 0}
	
		brain.clothing = {}
		brain.tint = {}
	
		brain.loot = {}
		brain.inventory = {}
		brain.tasks = {}
	
		-- bandit differentiators
		brain.rnd = {ZombRand(2), ZombRand(10), ZombRand(100), ZombRand(1000), ZombRand(10000)}
	
		brain.personality = {}
	
		-- addiction and sickness
		brain.personality.alcoholic = (ZombRand(50) == 0)
		brain.personality.smoker = (ZombRand(4) == 0)
		brain.personality.compulsiveCleaner = (ZombRand(90) == 0)
	
		-- collectors
		brain.personality.comicsCollector = (ZombRand(80) == 0)
		brain.personality.gameCollector = (ZombRand(220) == 0)
		brain.personality.hottieCollector = (ZombRand(100) == 0)
		brain.personality.toyCollector = (ZombRand(220) == 0)
		brain.personality.videoCollector = (ZombRand(220) == 0)
		brain.personality.underwearCollector = (ZombRand(150) == 0)
	
		-- heritage
		brain.personality.fromPoland = (ZombRand(120) == 0) 	
		brain.hostile = false
		brain.hostileP = false
	
		return brain
	end

ZomboLewdConfig.Modules.SpawnIsoZombieSurvivor = function(worldobjects, playerObj)
	DebugLog.log("[Zombolewd] /SpawnIsoZombieSurvivor/")

    -- Identify the first available world object
	local firstObject
	for _,o in ipairs(worldobjects) do
        if not firstObject then 
            firstObject = o 
        end
	end
	
	local offsetX = firstObject:getX()
	local offsetY = firstObject:getY()
	local cell = getWorld():getCell()	
	local desc = SurvivorFactory.CreateSurvivor()
	DebugLog.log("summoning zombie...")
	local zombie = createZombie(offsetX, offsetY, playerObj:getZ(), desc, 0, playerObj:getDir())
	zombie:setFemale(not playerObj:isFemale())	    
	--делаем зомби человекообразным (подсмотрено в моде bandits 2)
	local brain = prepare_brain(zombie)
	--zombie:GetModData().brain = brain
	local modData = zombie:getModData()
    modData.brain = brain
	--zombie:SetModData(brain)
	zombie:update()
	zombie:setWalkType("Walk")
	zombie:getEmitter():stopAll()
	--чистим модельку
    zombie:setPrimaryHandItem(nil)
    zombie:setSecondaryHandItem(nil)
    zombie:resetEquippedHandsModels()
    zombie:clearAttachedItems()
	--говорят, что чистит глюк с застреванием
	zombie:setTurnAlertedValues(-5, 5)
	--пишут, иначе игрушка вылетит
	zombie:setVariable("ZombieHitReaction", "Chainsaw")
	--делаем у зомби нормальный голос и кожу
	local desc = zombie:getDescriptor()
	local zombieVisuals = zombie:getVisual()
	zombieVisuals:removeBlood()	
    -- local test = desc:getVoicePrefix()	
	if (playerObj:isFemale()) then
    	desc:setVoicePrefix("female")
		zombieVisuals:setSkinTextureName("FemaleBody01")
	else
		desc:setVoicePrefix("male")
		zombieVisuals:setSkinTextureName("MaleBody01a")
	end	
	--на всякий случай обновляю графику
	zombie:resetModelNextFrame()
    zombie:resetModel()		
	--меняем поведение	
	zombie:setUseless(true)	
	zombie:clearAggroList()
	zombie:setTarget(nil)
	zombie:debugPrintout()
	DebugLog.log("Zombolewd SpawnIsoZombieSurvivor: npc added to world...")
end