require "ZomboLewd/ZomboLewdConfig"

ZomboLewdConfig.Modules.SpawnIsoSurvivor = function(worldobjects, playerObj)
	DebugLog.log("[Zombolewd] /SpawnIsoSurvivor/")
    -- Identify the first available world object
	local firstObject
	for _,o in ipairs(worldobjects) do
        if not firstObject then 
            firstObject = o 
        end
	end

	local offsetX = firstObject:getX()
	local offsetY = firstObject:getY()
    local desc = SurvivorFactory.CreateSurvivor(SurvivorType.Neutral, false)
    local hairColors = desc:getCommonHairColor()
	local cell = getWorld():getCell()
	SurvivorFactory.getRandomSurname()
	SurvivorFactory.getRandomForename(not playerObj:isFemale())
	SurvivorFactory.setTorso(desc)
    local survivorModel = IsoSurvivor.new(desc, cell, offsetX, offsetY, playerObj:getZ())
	--survivorModel:getInventory():emptyIt()
	if playerObj:isFemale() then
		survivorModel:setFemale(false)
		survivorModel:dressInNamedOutfit("Biker")
	else
		survivorModel:setFemale(true)
		survivorModel:dressInNamedOutfit("DressLong")
	end
	local bodyDamage = survivorModel:getBodyDamage()
	bodyDamage:setOverallBodyHealth(100)
	survivorModel:dressInRandomOutfit()
	--survivorModel:setSceneCulled(false) --Error in IsoGameCharacter.setSceneCulled(false):.
	--survivorModel:setBlockMovement(true) --почему-то выделяет этот момент в логах
	--survivorModel:setNPC(true)	
	--Cannot invoke "zombie.characters.BodyDamage.BodyDamage.getNumPartsBleeding()" because the return value of "zombie.characters.IsoGameCharacter.getBodyDamage()" is null at IsoGameCharacter.updateInternal(IsoGameCharacter.java:10740)
	survivorModel:setDir(playerObj:getDir())
	survivorModel:addToWorld()
	survivorModel:resetModelNextFrame()
	survivorModel:resetModel()	
	DebugLog.log("Zombolewd SpawnIsoSurvivor: npc added to world...")
end