--- Adds extra traits for the players to choose from
-- @author QueuedResonance 2022


require('NPCs/MainCreationMethods')

local TraitFactory = TraitFactory
local Perks = Perks

local getText = getText
local string = string

--- Table of all the traits relevant to ZomboLewd
local TRAITS_LIST = {
	{
		IdentifierType = "Sexaddict",
		Cost = -4,
		Profession = false,
		MutualExclusives = {},
	},
	{
		IdentifierType = "Rapist",
		Cost = 3,
		Profession = false,
		MutualExclusives = {},
		Callback = function(trait)
			trait:addXPBoost(Perks.Sneak, 1)
		end
	},
	{
		IdentifierType = "Necrophiliac",
		Cost = 3,
		Profession = false,
		MutualExclusives = {},
	},
	{
		IdentifierType = "Misogynist",
		Cost = -3,
		Profession = false,
		MutualExclusives = {},
	},
	{
		IdentifierType = "Misandrist",
		Cost = -3,
		Profession = false,
		MutualExclusives = {"Misogynist"},
	},
	{
		IdentifierType = "Peaceful",
		Cost = -2,
		Profession = false,
		MutualExclusives = {},
	},
	{
		IdentifierType = "Succuby",
		Cost = 2,
		Profession = false,
		MutualExclusives = {"Peaceful"},
	}
}

--- Load ZomboLewd specific traits
local function _initTraits()
	for i = 1, #TRAITS_LIST do
		local data = TRAITS_LIST[i]

		local name = getText(string.format("UI_ZL_Trait_%s", data.IdentifierType))
		local desc = getText(string.format("UI_ZL_Trait_%s_Description", data.IdentifierType))
		local newTrait = TraitFactory.addTrait(data.IdentifierType, name, data.Cost, desc, data.Profession)

		--- Activate optional callbacks
		if data.Callback then
			data.Callback(newTrait)
		end

		--- Make it so traits with mutual exclusivity can't select each other
		for v = 1, #data.MutualExclusives do
			TraitFactory.setMutualExclusive(data.IdentifierType, data.MutualExclusives[v])
		end
	end
end

function pStartGear(player)
	
	----------------------------------------------- Traits -----------------------------------------------
	if player:HasTrait("Rapist") then
		player:getInventory():AddItem("Base.Rope", 1);
		player:getInventory():AddItem("Base.DuctTape", 1);
		player:getInventory():AddItem("Base.KitchenKnife", 1);
	end	

	----------------------------------------------- Debug -----------------------------------------------
	local ZomboLewdModOptions = PZAPI.ModOptions:getOptions("ZomboLewdFramework")
	if ZomboLewdModOptions:getOption("box_debug"):getValue() == true then 
		player:getInventory():AddItem("Base.Rope", 1);
	end	

end

--- Hook up event listeners
Events.OnGameBoot.Add(_initTraits)
Events.OnNewGame.Add(pStartGear)