--Handle animation with Bandits mod actived

--[[
  Overview of ActionEvents hooks for animation sequences:
    • Perform      – after animation completes successfully
    • Start        – when animation begins
    • Stop         – if animation is cancelled
    • Update       – each frame while animation runs
    • WaitToStart  – while animation is pending start
]]
local ZomboLewd = require("ZomboLewd/ZomboLewd")
local ActionEvents = ZomboLewd.AnimationHandler.ActionEvents

DebugLog.log("[Zombolewd] /client/ZomboLewd/ZLModHanddler/Bandits.lua File loaded")
DebugLog.log("[Zombolewd] /_ZLModHandlersBandits/")
if getActivatedMods():contains("\\Bandits2") then    
    require "\\Bandits2/BanditUpdate" 
    -- перехват обработки событий для bandits
    function clear_bandit_hands(banditChar, task, brain)
        local inventory = banditChar:getInventory()
        if banditChar:getPrimaryHandItem() then
            inventory:AddItem(banditChar:getPrimaryHandItem())
            banditChar:setPrimaryHandItem(nil)
            banditChar:resetEquippedHandsModels()
        end
    end
    ZombieActions = ZombieActions or {}
    ZombieActions.CustomAnim = {}
    ZombieActions.CustomAnim.onStart	= clear_bandit_hands
    ZombieActions.CustomAnim.onWorking	= clear_bandit_hands
    ZombieActions.CustomAnim.onComplete	= clear_bandit_hands
    DebugLog.log("[Zombolewd] /client/ZomboLewd/ZLModHanddler/Bandits.lua Bandits mod found")

    table.insert(ActionEvents.Start, function(action)
        DebugLog.log("[Zombolewd] /client/ZomboLewd/ZLModHanddler/Bandits.lua /Start/")
        local otherAction = action.otherActions[2]
        if otherAction then
            local bandit = otherAction.character
            if bandit:isZombie() and bandit:getVariableBoolean("Bandit") then 
                DebugLog.log("bandit detected")               
                local task = {
                    action	= "CustomAnim",	
                    anim	= otherAction.animation,	
                    time	= action.duration,
                    state	= "NEW"	
                }
                -- Insert task into modData.brain.tasks for processing on client-side
                local md = bandit:getModData()
                md.brain = md.brain or {}
                md.brain.tasks = md.brain.tasks or {}
                table.remove(md.brain.tasks)
                table.insert(md.brain.tasks, task)
                DebugLog.log(string.format("Task inserted into md.brain.tasks, tasks count -> %d", #md.brain.tasks))
            end
        end
    end)

    table.insert(ActionEvents.Update, function(action)
        DebugLog.log("[Zombolewd] /client/ZomboLewd/ZLModHanddler/Bandits.lua /Update/")
        local otherAction = action.otherActions[2]
        if otherAction then
            local bandit = otherAction.character
            if bandit:isZombie() and bandit:getVariableBoolean("Bandit") then 
                DebugLog.log("bandit detected")               
                -- Insert task into modData.brain.tasks for processing on client-side
                local md = bandit:getModData()
                md.brain.tasks.state = "WORKING"
            end
        end
    end)   

    table.insert(ActionEvents.Stop, function(action)
        local character = action.character
        local otherAction = action.otherActions[2]
        if character:isZombie() and  character:getVariableBoolean("Bandit") then
            DebugLog.log("[Zombolewd] /client/ZomboLewd/ZLModHanddler/Bandits.lua /Stop/ self")
            local md = character:getModData()
            table.remove(md.brain.tasks)
        end
        if otherAction then
            local bandit = otherAction.character
            if bandit:isZombie() and  bandit:getVariableBoolean("Bandit") then
                DebugLog.log("[Zombolewd] /client/ZomboLewd/ZLModHanddler/Bandits.lua /Stop/ other")
                local othermd = bandit:getModData()
                table.remove(othermd.brain.tasks)
            end
        end
    end)

    table.insert(ActionEvents.Perform, function(action)
        local otherAction = action.otherActions[2]
        if otherAction then
            local bandit = otherAction.character
            if bandit:isZombie() and  bandit:getVariableBoolean("Bandit") then
                DebugLog.log("[Zombolewd] /client/ZomboLewd/ZLModHanddler/Bandits.lua /Perform/")
                local othermd = bandit:getModData()
                table.remove(othermd.brain.tasks)
            end
        end
    end)   

end