--[[
  Overview of ActionEvents hooks for animation sequences:
    • Perform      – after animation completes successfully
    • Start        – when animation begins
    • Stop         – if animation is cancelled
    • Update       – each frame while animation runs
    • WaitToStart  – while animation is pending start
]]

local ZomboLewd = require("ZomboLewd/ZomboLewd")
local ActionEvents = ZomboLewd.AnimationHandler.ActionEvents
local ZomboLewdModOptions = PZAPI.ModOptions:getOptions("ZomboLewdFramework")

-- Adjusts stress, unhappiness, boredom etc during ongoing animations
table.insert(ActionEvents.Update, function(action)
	local character = action.character
	if not action.character:isZombie() then 		
		local otherAction = action.otherAction

		local stats = character:getStats()
		local bodyDamage = character:getBodyDamage()
		local unhappiness = bodyDamage:getUnhappynessLevel()
		local boredom = bodyDamage:getBoredomLevel()
		local wetness = bodyDamage:getWetness()

		--- Gender hating logic
		if action.otherActions then
			for _, otherAction in ipairs(action.otherActions) do
				local otherCharacter = otherAction.character

				if character:HasTrait("Misogynist") then
					if otherCharacter:isFemale() then
						stats:setStress(stats:getStress() + 0.002)
						bodyDamage:setUnhappynessLevel(unhappiness + 0.005)
					end
				end

				if character:HasTrait("Misandrist") then
					if not otherCharacter:isFemale() then
						stats:setStress(stats:getStress() + 0.002)
						bodyDamage:setUnhappynessLevel(unhappiness + 0.005)
					end
				end
			end
		end

		if character:HasTrait("Sexaddict") then
			stats:setStress(stats:getStress() - 0.002)
			bodyDamage:setUnhappynessLevel(unhappiness - 0.005)
		end
		if (ZomboLewdModOptions:getOption("box_SFitness"):getValue()) then
			DebugLog.log("[Zombolewd] Improve Fitness (+0.05) and Strength(+0.02)")
			character:getXp():AddXP(Perks.Fitness, 0.05)
			character:getXp():AddXP(Perks.Strength, 0.02)
		end
		--- Decrease stress (grow up because zombie is near)
		stats:setStress(stats:getStress() - 0.002)
		--- Decrease boredom
		bodyDamage:setBoredomLevel(boredom - 0.005)
		--- Increase wetness
		if wetness < 40 then
			bodyDamage:setWetness(wetness + 0.1);
		end	
	end
end)

table.insert(ActionEvents.Perform, function(action)
	DebugLog.log("[Zombolewd] /ApplyBasicTraits.lua/ perform")
	local character = action.character
	local otherAction = action.otherAction
	if not character:isZombie() then 
		local stats = character:getStats()	
		local bodyDamage = character:getBodyDamage()
		local unhappiness = bodyDamage:getUnhappynessLevel()
		local bodyParts = bodyDamage:getBodyParts()
		if action.otherActions then
			for _, otherAction in ipairs(action.otherActions) do
				local otherCharacter = otherAction.character
				if otherCharacter:isZombie() then
					if action.character:HasTrait("Necrophiliac") then
						DebugLog.log("[Zombolewd] Apply Necrophiliac trait")
						bodyDamage:setUnhappynessLevel(unhappiness - 20)
						stats:setStress(stats:getStress() - 0.05)		
					end
					if ZomboLewdModOptions:getOption("box_SCureZ"):getValue() then
						DebugLog.log("[Zombolewd] Try to cure zombification")     
						for i = 0, bodyParts:size() - 1 do
							local part = bodyParts:get(i)
							if part:getWoundInfectionLevel() > 0 then
								DebugLog.log(string.format("zombification found on part: %s", tostring(part)))
								part:setWoundInfectionLevel(0)
							end
						end	
						bodyDamage:setInfected(false)
						bodyDamage:setInfectionTime(-1)			
					end
				end
				if action.character:HasTrait("Succuby") then	
					DebugLog.log("[Zombolewd] Apply Succuby trait")		
					otherCharacter:setVariable("MustDie", true)	
					bodyDamage:RestoreToFullHealth()
				end
			end
		end
	end
end)

-- Incremental unhappiness when idle for sex addicts
local function _onPlayerUpdate(character)
	if not character:isZombie() then 
		local stats = character:getStats()
		local bodyDamage = character:getBodyDamage()
		local unhappiness = bodyDamage:getUnhappynessLevel()

		if not character:getModData().zomboLewdSexScene then
			if character:HasTrait("Sexaddict") then
				bodyDamage:setUnhappynessLevel(unhappiness + 0.0002)
			end
		end
	end
end

--- Hook up event listeners
Events.OnPlayerUpdate.Add(_onPlayerUpdate) 