
if SimpleSilencersModelTable == nil then
    print("UniversalSS: ERROR: Univeral Simple Silencers unable to find SimpleSilencersModelTable!")
    return -1
else
    print("UniversalSS: Found existing SimpleSilencersModelTable")
end


UniversalSS = {}
UniversalSS.debug = true

function UniversalSS.debugSay(message)
    if UniversalSS.debug then
        print("UniversalSS: "..tostring(message))
    end
end


-- Figure out what sort of gun an item is
-- 0: Pistol
-- 1: Shotgun
-- 2: Longarm
-- nil: not a gun
function UniversalSS.findGunType(item)

    if item:getItemType() ~= ItemType.WEAPON then return nil; end -- not a weapon
    if item:isRanged() == false then return nil; end -- not a ranged weapon
    if item.projectileCount and item.projectileCount > 1 then return 1; end --found a shotgun!
    if item.twoHandWeapon  then return 2; end --found a longarm!
    return 0 -- guess it's a pistol. Or something else. Whatever. Silence your bow if you want.

end


-- update item script with attachment details
function UniversalSS.updatescript(item, siltype)
	--local script = ScriptManager.instance:getItem(item)
	if item then 
		if siltype == 0 then -- Pistols
			item:DoParam("ModelWeaponPart = Silencer SilencerRifle muzzle muzzle")
			item:DoParam("ModelWeaponPart = MetalPipeSilencer MetalPipeSilencer muzzle muzzle")
		elseif siltype == 1 then -- Shotguns
			item:DoParam("ModelWeaponPart = Silencer SilencerBig muzzle muzzle")
			item:DoParam("ModelWeaponPart = MetalPipeSilencer MetalPipeSilencerBig muzzle muzzle")
		elseif siltype == 2 then -- Rifles
			item:DoParam("ModelWeaponPart = Silencer SilencerRifle muzzle muzzle")
			item:DoParam("ModelWeaponPart = MetalPipeSilencer MetalPipeSilencerRifle muzzle muzzle")
		end
	end
end



-- find weapons, add silencers
function  UniversalSS.AddSS()
  UniversalSS.debugSay("Looking for firearms...");

  local items = getAllItems(); --ArrayList of Item
  local found = 0
  local modified = 0
  for i = 0, items:size() - 1, 1 do
    found = found + 1
    local item = items:get(i);
    local guntype = UniversalSS.findGunType(item)
    if guntype ~= nil then
      modified = modified +1
      UniversalSS.debugSay(item:getFullName()..": "..tostring(guntype));
      SimpleSilencersModelTable[item:getFullName()]=guntype
      UniversalSS.updatescript(item, guntype)
    end
  end
  UniversalSS.debugSay("Items Found: "..found.." Items Modified: "..modified);
  UniversalSS.debugSay("Finished");
end

-- attach event
Events.OnGameBoot.Add(UniversalSS.AddSS)






