-- Part A: The Reminder
local partA = {
    "If the hood opens",
    "The hood must stay closed",
    "Opening the hood",
    "I should keep the hood shut",
    "The hood is not to be lifted",
    "Leaving the hood up",
    "The hood cannot be opened",
    "It is best to keep the hood shut",
    "Touching the hood now"
}

-- Part B: The Condition
local partB = {
    "while the vehicle is in tow,",
    "as the car is being pulled,",
    "during the towing process,",
    "when the vehicle is being towed,",
    "while transport is underway,",
    "in the middle of a tow,",
    "as it's being hauled,",
    "while the tow is active,",
    "when the vehicle is towed,"
}

-- Part C: The Consequence
local partC = {
    "or damage could happen.",
    "it could cause harm.",
    "safety could be at risk.",
    "the car could be damaged.",
    "it is not safe.",
    "or problems could arise.",
    "the tow cannot continue.",
    "there could be danger.",
    "things could go wrong."
}

-- Function to pick a random entry from a table
local function randomPick(t)
    return t[ZombRand(#t) + 1] -- ZombRand is PZ's random (0-based)
end

-- Function to build the phrase
local function generatePhrase()
    return randomPick(partA) .. " " .. randomPick(partB) .. " " .. randomPick(partC)
end

-- Save reference to original function - must be done after vanilla loads
local oldEngineDoorUse = nil

-- Custom EngineDoor handler for towed vehicles
local function TowTruck_EngineDoor(vehicle, part, character)
    if vehicle then
        if vehicle:getModData()["isTowed"] then
            local thought = generatePhrase()
            if character then
                character:Say(thought)
                return
            end
        end
    end
    -- Call vanilla behavior
    if oldEngineDoorUse then
        oldEngineDoorUse(vehicle, part, character)
    end
end

-- Apply the override when server starts (ensures Vehicles.Use exists)
local function applyEngineDoorOverride()
    if Vehicles and Vehicles.Use and Vehicles.Use.EngineDoor then
        oldEngineDoorUse = Vehicles.Use.EngineDoor
        Vehicles.Use.EngineDoor = TowTruck_EngineDoor
    end
end

Events.OnServerStarted.Add(applyEngineDoorOverride)

