require('TimedActions/ISBaseTimedAction')

ISTowtruckSchedule = ISBaseTimedAction:derive("ISTowtruckSchedule")

-- The condition which tells the timed action if it is still valid
function ISTowtruckSchedule:isValid()
	return true
end

-- Starts the Timed Action
function ISTowtruckSchedule:start()	
end

-- Is called when the time has passed
function ISTowtruckSchedule:perform()
    if self.performFunc ~= nil then
        self.performFunc(self.character, self.arg1)
    end
	
    ISBaseTimedAction.perform(self)
end


function ISTowtruckSchedule:stop()
    ISBaseTimedAction.stop(self)
end

function ISTowtruckSchedule:new(character, time, performFunc, arg1, arg2, arg3, arg4)
    local o = ISBaseTimedAction.new(self, character)
	
	o.useProgressBar = false	
	o.stopOnWalk = false
	o.stopOnRun = false

    o.maxTime = time
	o.character = character
	
	o.performFunc = performFunc
	o.arg1 = arg1
	o.arg2 = arg2
	o.arg3 = arg3
	o.arg4 = arg4
   
    return o
end

