local InvMatrixCell = require("InvMatrixCell")
require("KnownAndCollected")

if not KnownAndCollected then
    return
end

local InvMatrixCell_isCompleted = InvMatrixCell.isCompleted
local InvMatrixCell_render = InvMatrixCell.render

local function getItemState(item)
    local state = {
        unCollected = false,
        unKnown = false,
        unKnownUnfinished = false,
        unKnownUnavailable = false,
        unPlayed = false,
        unKnownMap = false,
        unKnownMapStack = false,
        unKnownFlier = false,
        unKnownEntertainment = false,
        isMap = false,
    }
    if not item then
        return state
    end
    local player = getPlayer()
    -- Recorded media
    if item.isRecordedMedia and item:isRecordedMedia() then
        local mediaData = item:getMediaData()
        local mediaId = mediaData:getId()
        if not KnownAndCollected:isCollectedMedia(mediaId) then
            state.unCollected = true
        end
        local radio = getZomboidRadio()
        local recordedMedia = radio:getRecordedMedia()
        if not recordedMedia:hasListenedToAll(player, mediaData) then
            if KnownAndCollected:isSkillMedia(mediaId) then
                state.unKnown = true
            else
                state.unPlayed = true
            end
        end
    -- Literature
    elseif instanceof(item, "Literature") then
        local fullType = item:getFullType()
        local skillBook = SkillBook[item:getSkillTrained()]
        local recipes = item.getLearnedRecipes and item:getLearnedRecipes()
        local printMedia = item:hasModData() and item:getModData().printMedia
        if skillBook then
            if not KnownAndCollected:isCollected(fullType) then
                state.unCollected = true
            end
            local maxLevel = item:getMaxLevelTrained()
            local minLevel = item:getLvlSkillTrained()
            local playerLevel = player:getPerkLevel(skillBook.perk) + 1
            local pages = item:getNumberOfPages()
            local readPages = pages > 0 and player:getAlreadyReadPages(fullType) or false
            if readPages and readPages ~= pages and maxLevel >= playerLevel then
                if minLevel > playerLevel then
                    state.unKnownUnavailable = true
                elseif readPages > 0 then
                    state.unKnownUnfinished = true
                else
                    state.unKnown = true
                end
            end
        elseif recipes then
            if not KnownAndCollected:isCollected(fullType) then
                state.unCollected = true
            end
            local alreadyReadBook = player:getAlreadyReadBook()
            local knownRecipes = player:getKnownRecipes()
            if not alreadyReadBook:contains(fullType) or not knownRecipes:containsAll(recipes) then
                state.unKnown = true
            end
        elseif printMedia then
            if not KnownAndCollected:isCollected(printMedia) then
                state.unCollected = true
            end
            if not KnownAndCollected:isKnownPrintMedia(printMedia) then
                state.unKnownFlier = true
            end
        else
            local title = item:hasModData() and item:getModData().literatureTitle
            state.unKnownEntertainment = title and not player:isLiteratureRead(title)
            if title and not KnownAndCollected:isCollected(title) then
                state.unCollected = true
            end
        end
    -- Maps
    elseif item.isMap and item:IsMap() then
        state.isMap = true
        local fullType = item:getFullType()
        if not KnownAndCollected:isCollected(fullType) then
            state.unCollected = true
        end
        if not KnownAndCollected:isKnownMap(fullType) then
            state.unKnownMap = true
        end
    end
    return state
end

local getStackState = function(items)
    local state = {
        unCollected = true,
        unKnown = true,
        unKnownUnfinished = true,
        unKnownUnavailable = true,
        unPlayed = true,
        unKnownMap = true,
        unKnownMapStack = true,
        unKnownFlier = true,
        unKnownEntertainment = true,
        isMap = false,
    }
    for _, item in ipairs(items) do
        local itemState = getItemState(item)
        state.unCollected = state.unCollected and itemState.unCollected
        state.unKnown = state.unKnown and itemState.unKnown
        state.unKnownUnfinished = state.unKnownUnfinished and itemState.unKnownUnfinished
        state.unKnownUnavailable = state.unKnownUnavailable and itemState.unKnownUnavailable
        state.unPlayed = state.unPlayed and itemState.unPlayed
        state.unKnownMap = state.unKnownMap and itemState.unKnownMap
        state.unKnownFlier = state.unKnownFlier and itemState.unKnownFlier
        state.unKnownEntertainment = state.unKnownEntertainment and itemState.unKnownEntertainment
        if itemState.isMap then
            state.isMap = true
        end
    end
    return state
end

InvMatrixCell.isCompleted = function(self)
    local activatedMods = getActivatedMods()
    if activatedMods:indexOf("\\hideVanillaReadIcon") ~= -1 then
        return false
    end
    return InvMatrixCell_isCompleted(self)
end

InvMatrixCell.render = function(self, x, y)
    InvMatrixCell_render(self, x, y)
    local player = getPlayer()
    KnownAndCollected:init(player)
    local state = getStackState(self.items)
    if state.unCollected then
        self:drawIndicator(KnownAndCollected.textures.collected, x, y, 0.2, 0.8)
    end
    if state.unKnown then
        self:drawIndicator(KnownAndCollected.textures.unknown, x, y, 0.8, 0.8)
    elseif state.unKnownUnfinished then
        self:drawIndicator(KnownAndCollected.textures.unKnownUnfinished, x, y, 0.8, 0.8)
    elseif state.unKnownUnavailable then
        self:drawIndicator(KnownAndCollected.textures.unavailable, x, y, 0.8, 0.8)
    elseif state.unPlayed then
        self:drawIndicator(KnownAndCollected.textures.media, x, y, 0.8, 0.8)
    elseif state.unKnownMap then
        self:drawIndicator(KnownAndCollected.textures.unKnownMap, x, y, 0.8, 0.8)
    elseif state.unKnownFlier then
        self:drawIndicator(KnownAndCollected.textures.unKnownFlier, x, y, 0.8, 0.8)
    elseif state.unKnownEntertainment then
        self:drawIndicator(KnownAndCollected.textures.unKnownEntertainment, x, y, 0.8, 0.8)
    end
end
