local Pane = require("InvMatrixPane")
local Config = require("InvMatrixConfig")

local ISInventoryPage_createChildren = ISInventoryPage.createChildren
local ISInventoryPage_prerender = ISInventoryPage.prerender
local ISInventoryPage_onMouseDownOutside = ISInventoryPage.onMouseDownOutside
local ISInventoryPage_onMouseMoveOutside = ISInventoryPage.onMouseMoveOutside
local ISInventoryPage_onMouseUp = ISInventoryPage.onMouseUp
local ISInventoryPage_onMouseUpOutside = ISInventoryPage.onMouseUpOutside

ISInventoryPage.createChildren = function(self)
    ISInventoryPage_createChildren(self)
    local basePane = self.inventoryPane or nil
    if basePane then
        basePane:setVisible(false)
        self.gridPane = Pane:new(0, 0, 0, 0, self)
        self.gridPane:setContext({
            getInventory = function()
                return self.inventory
            end,
            getInventoryPane = function()
                return self.inventoryPane
            end,
            getItems = function()
                local array = self.inventory:getItems()
                local items = {}
                for i = 0, array:size() - 1 do
                    local item = array:get(i)
                    table.insert(items, item)
                end
                return items
            end,
            isOnCharacter = function()
                return self.onCharacter
            end,
        })
        self.gridPane:initialise()
        self:addChild(self.gridPane)
    end
end

ISInventoryPage.prerender = function(self)
    ISInventoryPage_prerender(self)
    local basePane = self.inventoryPane or nil
    if basePane then
        local x, y = basePane:getX(), basePane:getY()
        local width, height = basePane:getWidth(), basePane:getHeight()
        self.gridPane:setX(x + 1)
        self.gridPane:setY(y)
        self.gridPane:setWidth(width - 1)
        self.gridPane:setHeight(height - 1)
    end
end

ISInventoryPage.onMouseDownOutside = function(self, x, y)
    ISInventoryPage_onMouseDownOutside(self, x, y)
    local popup = self.gridPane and self.gridPane.popup or nil
    if popup and popup:isVisible() then
        self.isCollapsed = false
        self:clearMaxDrawHeight()
        self.collapseCounter = -40
    end
end

ISInventoryPage.onMouseMoveOutside = function(self, x, y)
    ISInventoryPage_onMouseMoveOutside(self, x, y)
    local popup = self.gridPane and self.gridPane.popup or nil
    if popup and popup:isVisible() then
        self.isCollapsed = false
        self:clearMaxDrawHeight()
        self.collapseCounter = -40
    end
end

ISInventoryPage.onMouseUp = function(self, x, y)
    ISInventoryPage_onMouseUp(self, x, y)
    local cellSize = Config.getCellSize()
    local baseWidth = self.inventoryPane:getWidth()
    local paneWidth = math.max(math.floor(baseWidth / cellSize), 6) * cellSize
    if paneWidth ~= baseWidth then
        local sidebarWidth = self.containerButtonPanel:getWidth()
        local winWidth = paneWidth + sidebarWidth
        self:setWidth(winWidth + 1)
    end
end

ISInventoryPage.onMouseUpOutside = function(self, x, y)
    ISInventoryPage_onMouseUpOutside(self, x, y)
    ISInventoryPage.onMouseUp(self, x, y)
end
