local M = {}

M.getOptionValue = function(id)
    local options = PZAPI.ModOptions:getOptions("InvMatrix")
    local option = options:getOption(id)
    return option:getValue()
end

M.setOptionValue = function(id, value)
    local options = PZAPI.ModOptions:getOptions("InvMatrix")
    local option = options:getOption(id)
    option:setValue(value)
end

M.getCellSize = function()
    local sizes = { 32, 40, 48 }
    local core = getCore()
    local sizeOption = core:getOptionInventoryContainerSize()
    local size = sizes[sizeOption] or 32
    local cellScale = M.getOptionValue("CellScale")
    return size * cellScale
end

return M
