local Constants = require("InvMatrixConstants")

Events.OnGameBoot.Add(function()
    local options = PZAPI.ModOptions:create("InvMatrix", "Inventory Matrix")
    options:addSlider("CellScale", "Cell Scale", 1, 2, 0.05, 1)
    local sortingOption = options:addComboBox("SortingMethod", "Sorting Method")
    for i, method in ipairs(Constants.SORTING_METHODS) do
        sortingOption:addItem(method, i == 0)
    end
    local equippedOption = options:addComboBox("CharacterEquippedItemsMode", "Character Equipped Items Mode")
    for i, mode in ipairs(Constants.EQUIPPED_MODES) do
        equippedOption:addItem(mode, i == 0)
    end
    options:addTickBox("DrawGridlines", "Draw Gridlines", true)
end)
