require "TimedActions/ISAddItemInRecipe"


ISAddItemInRecipe.checkName = function(baseItem, recipe)
    if not baseItem:getExtraItems() and not baseItem:getSpices() then
        return;
    end
    if baseItem:isCustomName() then
        return;
    end

    -- Default to false if the Mod Options framework isn't installed
    -- The option 'useShortNames' switches between using short names (e.g., "Salad") or full names (e.g., "Salad with Tomato, Lettuce, Onion")
    local useShortName = false
    local hideMinorIngredients = false
    if CCN_Options_ShortNames then
        useShortName = CCN_Options_ShortNames:getValue()
    end
    if CCN_Options_HideMinorIngredients then
        hideMinorIngredients = CCN_Options_HideMinorIngredients:getValue()
    end

    -- Setup constants
    local recipeBaseName = getText("ContextMenu_EvolvedRecipe_" .. recipe:getUntranslatedName())
    local MAX_INGREDIENT_COUNT = 3
    local COMMA = getText("ContextMenu_EvolvedRecipe_comma")
    local AND = getText("ContextMenu_EvolvedRecipe_and")
    local WITH = getText("ContextMenu_EvolvedRecipe_with")

    -- Build a list of food names
    local foodTypeList = {};
    local foodTypeListNoExplicit = {};
    if baseItem:getExtraItems() then
        for i = 0, baseItem:getExtraItems():size() - 1 do
            local food = baseItem:getExtraItems():get(i);
            local name = getItemEvolvedRecipeName(food) or getItemDisplayName(food);
            if isItemFood(food) then
                if hideMinorIngredients and (getItemFoodType(food) == "NoExplicit" or not getItemFoodType(food)) then -- no explicit appear only if there's no other ingredient inside the recipe
                    foodTypeListNoExplicit[name] = name
                else
                    foodTypeList[name] = name
                end
            end
        end
    end

    -- Extend the food names list with spices
    if baseItem:getSpices() then
        for i = 0, baseItem:getSpices():size() - 1 do
            local food = baseItem:getSpices():get(i);
            local name = getItemEvolvedRecipeName(food) or getItemDisplayName(food);
            if isItemFood(food) then
                if hideMinorIngredients and (getItemFoodType(food) == "NoExplicit" or not getItemFoodType(food) or hasItemTag(food, ItemTag.MINOR_INGREDIENT) ) then -- no explicit appear only if there's no other ingredient inside the recipe
                    foodTypeListNoExplicit[name] = name
                else
                    foodTypeList[name] = name
                end
            end
        end
    end

    -- Count valid ingredients
    local ingredientCount = 0
    for i, v in pairs(foodTypeList) do
        if v ~= "" then ingredientCount = ingredientCount + 1 end
    end

    -- If there are no valid normal ingredients, use the NoExplicit ingredients
    -- "No Explicit" ingredients are things like spices that are only shown if there are no other ingredients
    if ingredientCount == 0 then
        for i, v in pairs(foodTypeListNoExplicit) do
            if v ~= "" then ingredientCount = ingredientCount + 1 end
        end
        foodTypeList = foodTypeListNoExplicit
    end

    -- Build the ingredient list string. Spices are only shown if the total ingredient count is within the limit.
    local ingredientListName = ""
    local index = 0
    for type, name in pairs(foodTypeList) do
        if name ~= "" and index < MAX_INGREDIENT_COUNT then
            if index == 0 then
                ingredientListName = ingredientListName .. " " .. WITH .. " " .. name
            elseif index < MAX_INGREDIENT_COUNT then
                ingredientListName = ingredientListName .. COMMA .. " " .. name
            end
            index = index + 1
        end
    end

    -- Combine the recipe name with the ingredient list
    local newName = recipeBaseName .. ingredientListName
    if useShortName then
        newName = recipeBaseName
    end

    -- Set the new name
    baseItem:setName(newName)
    if not isServer() then
        ISInventoryPage.dirtyUI();
    end
end

