-- Create the main section in the "MODS" tab
local CCN_Options = PZAPI.ModOptions:create("ConsistentCookingNames", "Consistent Cooking Names")

-- Arguments: ID, Display Name, Default Value, Tooltip Description
CCN_Options_ShortNames = CCN_Options:addTickBox(
    "CCN_useShortNames",
    "Use Short Recipe Names",
    false,
    "When enabled, recipe names will only show the base recipe (e.g., 'Salad', 'Stir Fry', etc) and hide the list of ingredients. Only applies to newly created recipes."
)

CCN_Options_HideMinorIngredients = CCN_Options:addTickBox(
    "CCN_hideMinorIngredients",
    "Hide Minor Ingredients",
    false,
    "When enabled, minor ingredients (e.g., salt, pepper, oil, etc) will be hidden in the recipe names when major ingredients are present. Only applies to newly created recipes."
)