require "TimedActions/ISBaseTimedAction"
require "vl_quest_utils"

VL_ISTakeInfectedNPCSpecimen = ISBaseTimedAction:derive("VL_ISTakeInfectedNPCSpecimen")

local AddItemToContainer = VLF.AddItemToContainer
local RemoveItemFromContainer = VLF.RemoveItemFromContainer

function VL_ISTakeInfectedNPCSpecimen:isValid()
	if not self.character:getInventory():FindAndReturn("Base.Scalpel") or not self.character:getInventory():FindAndReturn("Base.VLEmptySpecimenContainer") then
		return false
	end
	return true
end

function VL_ISTakeInfectedNPCSpecimen:waitToStart()
	self.character:faceThisObject(self.zombie)
	return self.character:shouldBeTurning()
end

function VL_ISTakeInfectedNPCSpecimen:update()
	if not self.zombie:getVariableBoolean(VLF.npcData[self.qStep].variable) then
		self:stop()
	end

	self.character:faceThisObject(self.zombie)
	self.character:setMetabolicTarget(Metabolics.MediumWork)
end

function VL_ISTakeInfectedNPCSpecimen:start()
	self:setActionAnim("Loot")
	self.character:SetVariable("LootPosition", "Low")
	local priHandItem = instanceItem("Base.Scalpel")
	if priHandItem then self:setOverrideHandModels(priHandItem, nil)
	else self:setOverrideHandModels(nil, nil)
	end	
	self.character:reportEvent("TakeInfectedSpecimen")
end

function VL_ISTakeInfectedNPCSpecimen:stop()
	ISBaseTimedAction.stop(self)
end

function VL_ISTakeInfectedNPCSpecimen:perform()
	ISInventoryPage.renderDirty = true
	-- needed to remove from queue / start next.
	ISBaseTimedAction.perform(self)
end

function VL_ISTakeInfectedNPCSpecimen:complete()
	AddItemToContainer(self.character:getInventory(), nil, "Base.VLInfectedSpecimenContainer", 1)
	--self.character:getInventory():Remove(self.character:getInventory():getFirstType("Base.VLEmptySpecimenContainer"))
	RemoveItemFromContainer(self.character:getInventory(), nil, "Base.VLEmptySpecimenContainer", 1)
	local cData = self.zombie:getModData()
	if not cData.takenInfectedSpecimen then
		cData.takenInfectedSpecimen = true
		self.zombie:transmitModData()
	end
    return true
end

function VL_ISTakeInfectedNPCSpecimen:new(character, zombie, time, qStep)
    local o = {}
    setmetatable(o, self)
    self.__index = self
	o.character = character;
    --o.corpseSquare = corpse:getSquare()
	--o.corpseItem = corpse:getItem()
	o.zombie = zombie
	o.qStep = qStep
    o.stopOnWalk = true
    o.stopOnRun = true
    o.caloriesModifier = 8
    o.maxTime = time
	o.forceProgressBar = true;
	if character:isTimedActionInstant() then
        o.maxTime = 1
    end
    return o
end

