--KHI NHẤP CHUỘT PHẢI -> HIỂN THỊ LỰA CHỌN TƯƠNG TÁC VỚI ĐỐI TƯỢNG NHIỆM VỤ

require "vl_quest_utils"
require "npc/vl_quest_npc_client"

VLF = VLF or {}

local Func = {}
Func.GetZombieOnlineIDorUID = VLF.GetZombieOnlineIDorUID
Func.GetQuestGlobalModData = VLF.GetQuestGlobalModData
Func.NPCTurnToZombie = VLF.NPCTurnToZombie

local function DoTakeBloodSample(player, corpse)
	local inv = player:getInventory()
	local item = inv:FindAndReturn("Base.VLEmptySyringe")
	if item then
		local square = player:getCurrentSquare()
		local sq = corpse:getSquare()
		--if square and sq and square ~= sq then
		if square and sq then
			local adjacent = AdjacentFreeTileFinder.Find(sq, player)
			if adjacent then
				ISTimedActionQueue.add(ISWalkToTimedAction:new(player, adjacent))
				ISTimedActionQueue.add(VL_ISTakeBloodSample:new(player, corpse, 300))
			end
		end
	else
		HaloTextHelper.addBadText(player, getText("IGUI_VLQ_NotHaveEmptySyringe"))
	end
end

--Thêm lựa chọn Get Blood Sample khi click ô có xác zombie
function VLF.AddContextMenu_BloodSample(playerIndex, context, worldobjects, test)
	local player = getSpecificPlayer(playerIndex)
	local mx, my = ISCoordConversion.ToWorld(getMouseXScaled(), getMouseYScaled(), player:getZ())
    local square = getCell():getGridSquare(math.floor(mx), math.floor(my), math.floor(player:getZ()))
	local objs = square:getStaticMovingObjects()
	for i = 0, objs:size() - 1 do
		local obj = objs:get(i)
		if obj and obj:isZombie() and instanceof(obj, "IsoDeadBody") and not obj:isSkeleton() then
		--print("Client-----------AddContextMenu_BloodSample= ")
			local cData = obj:getModData()
			if not cData.takenBloodSample then
				context:addOption(getText("IGUI_VLQ_TakeBloodSample"), player, DoTakeBloodSample, obj)
			end
		end
	end
end
--Events.OnPreFillWorldObjectContextMenu.Remove(VLF.AddContextMenu_BloodSample)
--Events.OnPreFillWorldObjectContextMenu.Add(VLF.AddContextMenu_BloodSample)

-----------------------------------------------------------
local function DoTakeZombieSpecimen(player, zombie)
	local inv = player:getInventory()
	local item1 = inv:FindAndReturn("Base.VLEmptySpecimenContainer")
	if item1 then
		local item2 = inv:FindAndReturn("Base.Scalpel")
		if item2 then
			local square = player:getCurrentSquare()
			local sq = zombie:getSquare()
			if square and sq then
				ISTimedActionQueue.add(ISWalkToTimedAction:new(player, sq))
				ISTimedActionQueue.add(VL_ISTakeZombieSpecimen:new(player, zombie, 500))
			end
		else
			HaloTextHelper.addBadText(player, getText("IGUI_VLQ_NotHaveScalpel"))
		end
	else
		HaloTextHelper.addBadText(player, getText("IGUI_VLQ_NotHaveEmptySpecimenContainer"))
	end
end

--Thêm lựa chọn Take Zombie's Specimen khi click ô có zombie đang nằm
function VLF.AddContextMenu_ZombieSpecimen(playerIndex, context, worldobjects, test)
	local player = getSpecificPlayer(playerIndex)
	local mx, my = ISCoordConversion.ToWorld(getMouseXScaled(), getMouseYScaled(), player:getZ())
    local square = getCell():getGridSquare(math.floor(mx), math.floor(my), math.floor(player:getZ()))
	local objs = square:getMovingObjects()
	for i = 0, objs:size() - 1 do
		local obj = objs:get(i)
		if obj and obj:isZombie() and obj:getActionStateName() == "onground" then
			--print("Client-----------AddContextMenu_ClickSquare= ")
			local cData = obj:getModData()
			if not cData.takenZombieSpecimen then
				context:addOption(getText("IGUI_VLQ_TakeZombieSpecimen"), player, DoTakeZombieSpecimen, obj)
			end
		end
	end
end
--Events.OnPreFillWorldObjectContextMenu.Remove(VLF.AddContextMenu_ZombieSpecimen)
--Events.OnPreFillWorldObjectContextMenu.Add(VLF.AddContextMenu_ZombieSpecimen)

-----------------------------------------------------------
local function DoTakeInfectedSpecimen(player, zNPC, qStep)
	local inv = player:getInventory()
	local item1 = inv:FindAndReturn("Base.VLEmptySpecimenContainer")
	if item1 then
		local item2 = inv:FindAndReturn("Base.Scalpel")
		if item2 then
			local square = player:getCurrentSquare()
			local sq = zNPC:getSquare()
			if square and sq then
				local adjacent = AdjacentFreeTileFinder.Find(sq, player)
				if adjacent then
					ISTimedActionQueue.add(ISWalkToTimedAction:new(player, adjacent))
					ISTimedActionQueue.add(VL_ISTakeInfectedNPCSpecimen:new(player, zNPC, 500, qStep))			
				end
			end
		else
			HaloTextHelper.addBadText(player, getText("IGUI_VLQ_NotHaveScalpel"))
		end
	else
		HaloTextHelper.addBadText(player, getText("IGUI_VLQ_NotHaveEmptySpecimenContainer"))
	end
end

local function TalkToInfectedNPC(player, square, zNPC, qStep)
	Func.NPCTurnToZombie(player, zNPC, qStep, {isPopUp = false})
end

--Thêm lựa chọn Take Infected NPC's Specimen khi click ô có NPC
function VLF.AddContextMenu_InfectedSpecimen(playerIndex, context, worldobjects, test)
	local player = getSpecificPlayer(playerIndex)
	local mx, my = ISCoordConversion.ToWorld(getMouseXScaled(), getMouseYScaled(), player:getZ())
    local square = getCell():getGridSquare(math.floor(mx), math.floor(my), math.floor(player:getZ()))
	local objs = square:getMovingObjects()
	for i = 0, objs:size() - 1 do
		local zNPC = objs:get(i)
		if zNPC and zNPC:isZombie() then
            local questMD = Func.GetQuestGlobalModData({qStep = nil})
            local zID = Func.GetZombieOnlineIDorUID(zNPC)
            local qStep = questMD.NPCqStep[zID]
            if qStep and zNPC:getVariableBoolean(VLF.npcData[qStep].variable) and VLF.npcData[qStep].infected then
				local cData = zNPC:getModData()
				context:addOption(getText("IGUI_VLQ_Talk"), player, TalkToInfectedNPC, square, zNPC, qStep)
				if not cData.takenInfectedSpecimen then
					context:addOption(getText("IGUI_VLQ_TakeInfectedSpecimen"), player, DoTakeInfectedSpecimen, zNPC, qStep)
				end
			end
		end
	end
end
--Events.OnPreFillWorldObjectContextMenu.Remove(VLF.AddContextMenu_InfectedSpecimen)
--Events.OnPreFillWorldObjectContextMenu.Add(VLF.AddContextMenu_InfectedSpecimen)