--ĐÁNH DẤU VỊ TRÍ QUEST TRÊN BẢN ĐỒ
--CALL FUNCTION: VLF.MarkerList_Add({qStep = "q1s001", x = 10650, y = 10070, texture = getTexture("media/textures/questmarker_48.png")})
--------VLF.MarkerList_Remove(qStep)

VLF = VLF or {}
VLF.MarkerList = VLF.MarkerList or {}
--VLF.MarkerList["q1s000test"] = {x = 10650, y = 9970, texture = getTexture("media/textures/questmarker_48.png")} --thêm giá trị

function VLF.MarkerList_Add(args) --VLF.MarkerList_Add({qStep = "q1s001", x = 10650, y = 10070, texture = getTexture("media/textures/questmarker_48.png")})
    local qStep = args.qStep
    if qStep and not VLF.MarkerList[qStep] then
        local x, y, texture = args.x, args.y, args.texture
        VLF.MarkerList[qStep] = {x = x, y = y, texture = texture}
    end
end

function VLF.MarkerList_Remove(qStep)
    if VLF.MarkerList[qStep] then
        VLF.MarkerList[qStep] = nil
    end
end

--Vẽ đánh dấu nhiệm vụ trên World Map
local oldMapRender = ISWorldMap.render
function ISWorldMap:render()
    oldMapRender(self) --render map default
    
    if not VLF.MarkerList then return end
    for qStep, data in pairs(VLF.MarkerList) do
        -- vẽ marker bằng texture mỗi frame
        local x, y, texture = data.x, data.y, data.texture or getTexture("media/textures/questmarker_48.png")
        if x and y then
            local xUI = self.mapAPI:worldToUIX(x, y)
            local yUI = self.mapAPI:worldToUIY(x, y)
            self:drawTextureScaledAspect(texture, xUI - 16, yUI - 16, 32, 32, 1, 1, 1, 1)
        end
    end
end

--Vẽ đánh dấu trên Minimap
local oldMiniRender = ISMiniMapOuter.render
function ISMiniMapOuter:render(...)
    oldMiniRender(self, ...)

    if not VLF.MarkerList then return end
    if not self.inner or not self.inner.mapAPI then return end

    -- Đặt vùng vẽ trong minimap
    self.inner:setStencilRect(0, 0, self:getWidth(), self:getHeight())

    for qStep, data in pairs(VLF.MarkerList) do
        local x, y, texture = data.x, data.y, data.texture or getTexture("media/textures/questmarker_48.png")
        if x and y then
            local xUI = self.inner.mapAPI:worldToUIX(x, y)
            local yUI = self.inner.mapAPI:worldToUIY(x, y)
            self.inner:drawTextureScaledAspect(texture, xUI - 8, yUI - 8, 16, 16, 1, 1, 1, 1)
        end
    end
    -- Kết thúc vùng vẽ
    self.inner:clearStencilRect()
end










