--HIỆN BẢNG THÔNG BÁO NỘI DUNG TÌNH TIẾT NHIỆM VỤ - CỬA SỔ NHỎ GIỮA MÀN HÌNH
--HIỆN BẢNG FULL MÀN HÌNH - CHÈN ẢNH FULL DẪN DẮT KỂ TRUYỆN

--CALL FUNCTION: VLF.ActiveQuestIntro_Centre(getText("IGUI_VLQ_1_Desc_q1s001"), 800, 500, false, "")
--------VLF.ActiveQuestIntro_FullScreen(getText("IGUI_VLQ_1_Desc_q1s001"), true, getTexture("media/ui/spiffo_bw1.png"))
--------VLF.ActiveQuestIntro_Free(text, x, y, width, height, isAddTexture, texture)

require "vl_quest_utils"

VL_Quest_IntroWindow_UI = ISPanel:derive("VL_Quest_IntroWindow_UI")
VLF = VLF or {}

local SplitTextByLength = VLF.SplitTextByLength
local IsMultiplayerMode = VLF.IsMultiplayerMode

function VL_Quest_IntroWindow_UI:new(text, x, y, width, height, isAddTexture, texture)
    local o = ISPanel.new(self, x, y, width, height)
    o.text = text or "nothing!"
    o.isAddTexture = isAddTexture
    o.texture = texture
    o.moveWithMouse = false
    o.backgroundColor = {r=0, g=0, b=0, a=0.7}
    o.borderColor = {r=1, g=1, b=1, a=1}
    o:setAlwaysOnTop(true)
    o.keepOnScreen = true
    o:setWantKeyEvents(true)
    return o
end

function VL_Quest_IntroWindow_UI:initialise()
    ISPanel.initialise(self)
    
    local btnW, btnH = 200, 60
    local btnX = (self.width - btnW) / 2
    local btnY = self.height - btnH - 15

    -- Nút Xác nhận
    self.okBtn = ISButton:new(btnX, btnY, btnW, btnH, getText("IGUI_VLQ_Confirm"), self, VL_Quest_IntroWindow_UI.onConfirm)
    self.okBtn.font = UIFont.NewLarge
    self.okBtn:initialise()
    self.okBtn:instantiate()
    self.okBtn.borderColor = {r=1, g=1, b=1, a=0.7}
    self:addChild(self.okBtn)
    
    --Khởi tạo khu vực trong UI có thể scroll chuột
    local screenWidth = getCore():getScreenWidth()
    if screenWidth > self.width then 
        self.questIntro = ISScrollingListBox:new(10, 10, self.width - 20, self.height - 90)
        self.questIntro:initialise()
        self.questIntro:instantiate()
        self.questIntro.itemheight = self.questIntro.height
        self.questIntro.selected = 0
        self.questIntro.joypadParent = self
        self.questIntro.font = UIFont.NewSmall
        self.questIntro.doDrawItem = self.drawIntroItem
        self.questIntro.drawBorder = true
        self:addChild(self.questIntro)
        self.questIntro:addItem("intro1", { id = 1, intro = self.text})
    end
end

function VL_Quest_IntroWindow_UI:drawIntroItem(y, item, alt)
    local a = 0.8
    local xOffset = 20
    local yOffset = 15
    local qData = item.item
    local itemHeight = self.itemheight
    local fontHeightSmall = getTextManager():getFontHeight(UIFont.Small)
    --Thay văn bản thuần <LINE> thành ký tự ASCII 10 \n để nhận dạng lệnh xuống dòng
    local text = qData.intro:gsub("<LINE>", "\n")

    --Chia dòng theo \n
    local lines = {}
    for line in text:gmatch("([^\n]+)") do
        table.insert(lines, line)
    end
    
    --Chia dòng khi vượt quá giới hạn ký tự
    local _lines = {}
    for _,line in ipairs(lines) do
        if line == " " then
            table.insert(_lines, line)
        else            
            local result = SplitTextByLength(line, self.width * 0.94, UIFont.NewSmall)
            for i, l in ipairs(result) do
                table.insert(_lines, l)
            end
        end
    end
    
    --Tăng chiều cao cho border nếu có nhiều dòng text
    if #_lines > 14 then
        local i = #_lines - 14
        itemHeight = itemHeight + i * fontHeightSmall
    end

    --Vẽ đường viền mỗi item
    self:drawRectBorder(0, (y), self:getWidth(), itemHeight - 1, a, 1, 1, 1)
    if self.selected == item.index then
        self:drawRect(0, (y), self:getWidth(), itemHeight - 1, a, 0, 0, 0)
    end
    --Vẽ text
    for i,line in ipairs(_lines) do
        self:drawText(line, xOffset, yOffset, 1, 1, 1, a, UIFont.Small)
        yOffset = yOffset + fontHeightSmall
    end
    return y + itemHeight
end

function VL_Quest_IntroWindow_UI:prerender()
    self:drawRect(0, 0, self:getWidth(), self:getHeight(), 0.9, 0, 0, 0)
    if self.isAddTexture == true then
        if not self.imageBackground then
            local texture = self.texture or getTexture("media/ui/background_intro.png")
            if texture then
                self.imageBackground = self:drawTextureScaled(texture, 0, 0, self.width, self.height, 1)
            end
        end
    end
end

function VL_Quest_IntroWindow_UI:render()
    ISPanel.render(self)
    -- Vẽ khung viền
    self:drawRectBorder(0, 0, self.width, self.height, 0.7, 1, 1, 1)
    
    -- Vẽ text giữa màn hình khi panel hiện full màn hình
    local screenWidth = getCore():getScreenWidth()
    if screenWidth == self.width then
        local y = self.height / 4
        local fontHeightSmall = getTextManager():getFontHeight(UIFont.Small)
        local lines = SplitTextByLength(self.text, 100)
        for i, line in ipairs(lines) do
            self:drawTextCentre(line, self.width / 2, y, 1, 1, 1, 0.8, UIFont.NewSmall)
            y = y + fontHeightSmall
        end
    end
end

-- Khi nhấn nút Xác nhận
function VL_Quest_IntroWindow_UI:onConfirm()
    self:removeFromUIManager()
end

--Close khi ấn ESC
function VL_Quest_IntroWindow_UI:onKeyRelease(key)
    if key == Keyboard.KEY_ESCAPE or key == Keyboard.KEY_RETURN then
        self:removeFromUIManager()
        return
    end
end

-- Hàm gọi để hiển thị panel ở giữa màn hình
function VLF.ActiveQuestIntro_Centre(text, width, height, isAddTexture, texture)
    local x = (getCore():getScreenWidth() - width) / 2
    local y = (getCore():getScreenHeight() - height) / 2
    if text and x and y and width and height then
        local ui = VL_Quest_IntroWindow_UI:new(text, x, y, width, height, isAddTexture, texture)
        ui:initialise()
        ui:addToUIManager()
        --đóng bảng nhiệm vụ nếu đang mở
        local VLF_QuestUI = VLF.QuestUI
        if VLF_QuestUI and VLF_QuestUI.window then VLF_QuestUI.window:close() end
        return ui
    end
end

-- Hàm gọi để hiển thị panel full màn hình
function VLF.ActiveQuestIntro_FullScreen(text, isAddTexture, texture)
    local core = getCore()
    local screenWidth = core:getScreenWidth()
    local screenHeight = core:getScreenHeight()
    local x = 0
    local y = 0
    if text and x and y and screenWidth and screenHeight then
        if not IsMultiplayerMode() then
            --FIXME: Khi vừa vào game hiển thị Panel này thì bị báo lỗi
            --local function OnGameStart()
            --    setGameSpeed(0)
            --    Events.OnGameStart.Remove(OnGameStart)
            --end
            --Events.OnGameStart.Add(OnGameStart)
        end
        local ui = VL_Quest_IntroWindow_UI:new(text, x, y, screenWidth, screenHeight, isAddTexture, texture)
        ui:initialise()
        ui:addToUIManager()
        --đóng bảng nhiệm vụ nếu đang mở
        local VLF_QuestUI = VLF.QuestUI
        if VLF_QuestUI and VLF_QuestUI.window then VLF_QuestUI.window:close() end
        return ui
    end
end

-- Hiển thị khung tự do kích thước và vị trí
function VLF.ActiveQuestIntro_Free(text, x, y, width, height, isAddTexture, texture)
    local x = x
    local y = y
    if text and x and y and width and height then
        local ui = VL_Quest_IntroWindow_UI:new(text, x, y, width, height, isAddTexture, texture)
        ui:initialise()
        ui:addToUIManager()
        --đóng bảng nhiệm vụ nếu đang mở
        local VLF_QuestUI = VLF.QuestUI
        if VLF_QuestUI and VLF_QuestUI.window then VLF_QuestUI.window:close() end
        return ui
    end
end



