--FUNCTION ĐỂ LẤY THÔNG TIN OUTFIT CHO NPC

function VLF.GetHairStyleID(isFemale, _hairStyle) --VLF.GetHairStyleID(false, "Baldspot")
    local hairStyles = getAllHairStyles(isFemale)
    local hs = {}
    for i=0, hairStyles:size()-1 do
        local hairStyle = hairStyles:get(i)
        local hairStyleInst
        if isFemale then hairStyleInst = getHairStylesInstance():FindFemaleStyle(hairStyle) 
        else hairStyleInst = getHairStylesInstance():FindMaleStyle(hairStyle) end
        if not hairStyleInst:isNoChoose() then
            table.insert(hs, hairStyle)
        end
    end
    local id
    for j, hairStyle in ipairs(hs) do
        if hairStyle == _hairStyle then
            id = j
            print("HAIR --- id = "..tostring(j).." --- hairStyle = "..tostring(hairStyle))
        end
    end
    return id
end

function VLF.GetBeardStyleID(_beardStyle)
    local beardStyles = getAllBeardStyles()
    local id
    for i = 0, beardStyles:size()-1 do
        local beardStyle = beardStyles:get(i)
        if beardStyle == _beardStyle then
           id = i
           print("BEARD --- id = "..tostring(i).." --- beardStyle = "..tostring(beardStyle))
        end
    end
    return id
end

--LẤY TÊN BỘ PHẬN VÀ TÊN ITEM ĐANG MẶC của PLAYER. 
function VLF.CheckAllEquipmentPlayer()
    local player = getPlayer()
    local wornItems = player:getWornItems()
print("-------------CheckAllEquipmentPlayer-----------------------= ")
    for i = 0, wornItems:size() - 1 do
        local item = wornItems:get(i):getItem()
        local visual = item:getVisual()
        local colorTab = visual:getTint()
        local loc = wornItems:get(i):getLocation()
        if item then
            print(string.format("%s = \"%s\"", loc, item:getFullType()))
            if colorTab then
                print(string.format("{r = %s, g = %s, b = %s, a = %s}", string.format("%.3f", colorTab:getRedFloat()), string.format("%.3f", colorTab:getGreenFloat()), string.format("%.3f", colorTab:getBlueFloat()), tostring(colorTab:getAlphaFloat())))
            end
        end
    end
end

--LẤY TÊN BỘ PHẬN VÀ TÊN ITEM ĐANG MẶC của ZOMBIE + TÓC, RÂU. 
function VLF.CheckAllEquipmentZombie()
    local zombies = getCell():getZombieList()
    for i = 0, zombies:size()-1 do
        local zombie = zombies:get(i)
        if zombie then
            print("-------------CheckAllEquipmentZombie-----------------------= ")
            --quần áo phụ kiện
            local visuals = zombie:getItemVisuals()
            for j = 0, visuals:size() - 1 do
                local visual = visuals:get(j)
                local colorTab = visual:getTint()
                local item = visual:getItemType()
                local itemScript = getScriptManager():FindItem(item)
                local loc = itemScript:getBodyLocation()
                if visual then
                    print(string.format("%s = \"%s\",", loc, item))
                    if colorTab then
                        print(string.format("{r = %s, g = %s, b = %s, a = %s}", string.format("%.3f", colorTab:getRedFloat()), string.format("%.3f", colorTab:getGreenFloat()), string.format("%.3f", colorTab:getBlueFloat()), tostring(colorTab:getAlphaFloat())))
                    end
                end
            end
            
            --skin, tóc, râu
            local npcVisuals = zombie:getHumanVisual()
            local hairStyle = npcVisuals:getHairModel()
            local hairColorTab = npcVisuals:getHairColor()
            local beardStyle = npcVisuals:getBeardModel()
            local beardColorTab = npcVisuals:getBeardColor()
            local skinTexture = npcVisuals:getSkinTexture()
            local isFemale = zombie:isFemale()
            local hairID = VLF.GetHairStyleID(isFemale, hairStyle)
            local beardID = VLF.GetBeardStyleID(beardStyle)
            
            print("-------- Skin Texture = "..tostring(skinTexture))
            print("-------- Hair Style = "..tostring(hairStyle).." --- ID = "..tostring(hairID))
            print(string.format("{r = %s, g = %s, b = %s, a = %s},", string.format("%.3f", hairColorTab:getRedFloat()), string.format("%.3f", hairColorTab:getGreenFloat()), string.format("%.3f", hairColorTab:getBlueFloat()), tostring(hairColorTab:getAlphaFloat())))
            if beardStyle then
                print("-------- Beard Style = "..tostring(beardStyle).." --- ID = "..tostring(beardID))
                print(string.format("{r = %s, g = %s, b = %s, a = %s},", string.format("%.3f", beardColorTab:getRedFloat()), string.format("%.3f", beardColorTab:getGreenFloat()), string.format("%.3f", beardColorTab:getBlueFloat()), tostring(beardColorTab:getAlphaFloat())))
                --print(string.format("{r = %s}", string.format("%.3f", 0.552334)))
            end
        end
    end
end

--LẤY TẤT CẢ ATTACHMENT TYPE VÀ ATTACHMENT LOCATION
function VLF.GetAllAttachmentType()
    for _, def in pairs(ISHotbarAttachDefinition) do
        print(def.type)
    end
    
    print("-------------AttachmentType --- Location-------------")
    for i, def in pairs(ISHotbarAttachDefinition) do
        if def.attachments then
            for k, v in pairs(def.attachments) do
                print(k.." --- "..v)
            end
        end
    end
end

--LẤY TẤT CẢ ITEM ĐANG ĐƯỢC ATTACHED TRÊN PLAYER
function VLF.GetAllAttachedItemsOnPlayer()
    local attachedItems = getPlayer():getAttachedItems()
    print("----------Item Full Type --- Attached Type --- Attached Location----------Player")
    for i=0, attachedItems:size()-1 do
        local attachedItem = attachedItems:get(i)
        if attachedItem then
            print("[\""..attachedItem:getLocation().."\"]".." = \""..attachedItem:getItem():getFullType().."\" --- "..attachedItem:getItem():getAttachmentType())
        end
    end
end

--LẤY TẤT CẢ ITEM ĐANG ĐƯỢC ATTACHED TRÊN ZOMBIE
function VLF.GetAllAttachedItemsOnZombie()
    local zombies = getCell():getZombieList()
    for i = 0, zombies:size()-1 do
        local zombie = zombies:get(i)
        if zombie then
            local attachedItems = zombie:getAttachedItems()
            print("----------Item Full Type --- Attached Type --- Attached Location----------Zombie")
            for i=0, attachedItems:size()-1 do
                local attachedItem = attachedItems:get(i)
                if attachedItem then
                    print("[\""..attachedItem:getLocation().."\"]".." = \""..attachedItem:getItem():getFullType().."\" --- "..attachedItem:getItem():getAttachmentType())
                end
            end
        end
    end
end
