--NÓI CHUYỆN VỚI NPC

require "vl_quest_utils"
require "vl_quest1_questupdate"
require "vl_quest1_playerglobalmoddata"
require "questui/vl_quest_introwindow_ui"
require "questui/vl_quest_popup_ui"
require "npc/vl_quest_npc_client"

VLF = VLF or {}
VLF.TalkToNPC = VLF.TalkToNPC or {}

local DoQuestStepActive = VLF.DoQuestStepActive
local UpdateNPCToNextQStep = VLF.UpdateNPCToNextQStep

local Func = {}
Func.GetPlayerGlobalModDataQ1 = VLF.GetPlayerGlobalModDataQ1
Func.ActiveQuestIntro_Centre = VLF.ActiveQuestIntro_Centre
Func.ActiveQuestIntro_Free = VLF.ActiveQuestIntro_Free
Func.QuestUpdatedPopIn = VLF.QuestUpdatedPopIn
Func.GetFoodInContainer = VLF.GetFoodInContainer
Func.GetWaterInContainer = VLF.GetWaterInContainer
Func.GetItemInContainer = VLF.GetItemInContainer
Func.GetAlcoholsInContainer = VLF.GetAlcoholsInContainer
Func.GetZombieOnlineIDorUID = VLF.GetZombieOnlineIDorUID
Func.GetAllnpcIDSpawning = VLF.GetAllnpcIDSpawning
Func.GetZombiesAroundSquare = VLF.GetZombiesAroundSquare
Func.IsPlayerInArea = VLF.IsPlayerInArea
Func.GetPlayerModData = VLF.GetPlayerModData
Func.NPCTurnToZombie = VLF.NPCTurnToZombie
Func.DelayFunction = VLF.DelayFunction
Func.RemoveNPCQuest = VLF.RemoveNPCQuest
Func.NPCInQueueSpawnList = VLF.NPCInQueueSpawnList
Func.IsMultiplayerMode = VLF.IsMultiplayerMode
Func.PlaySound = VLF.PlaySound
Func.SendAddItemToContainer = VLF.SendAddItemToContainer
Func.AddItemToContainer = VLF.AddItemToContainer
Func.RemoveItemFromContainer = VLF.RemoveItemFromContainer

--qStep_Next = qStep + 1
local function CalculateQStepNext(qStep)
	local qStep_Next
	local nextNum = tonumber(string.sub(qStep, -3)) + 1
	if nextNum then
		if nextNum < 10 then qStep_Next = "q1s".."00"..tostring(nextNum)
		elseif nextNum < 100 then qStep_Next = "q1s".."0"..tostring(nextNum)
		else qStep_Next = "q1s"..tostring(nextNum) end
	end
	return qStep_Next
end

--NPC phản hồi khi đang chờ tiến sĩ nghiên cứu
local function WaitQuestActiveWhenNPCTalk(player, square, zNPC, qStep)
	local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
	--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
	if playerGMD_Quest_Q1[qStep].active == true then
		if not playerGMD_Quest_Q1[qStep].waitHourPassed then
			Func.ActiveQuestIntro_Free(getText("IGUI_VLQ_2_Notification1_q1s019"), (getCore():getScreenWidth() - 800) / 2, (getCore():getScreenHeight() - 200) / 16, 800, 200, false, "")
		end
	end
	--cập nhật qStep cho NPC để không phải load lại NPC
	local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
	--local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep_Next})
	if playerGMD_Quest_Q1[qStep_Next] and playerGMD_Quest_Q1[qStep_Next].active == true then
		if playerGMD_Quest_Q1[qStep].waitHourPassed == true then
			UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
			VLF.TalkToNPC[qStep_Next](player, square, zNPC, qStep_Next)
			--Func.ActiveQuestIntro_Free(getText("IGUI_VLQ_2_Notification2_q1s019"), (getCore():getScreenWidth() - 800) / 2, (getCore():getScreenHeight() - 200) / 16, 800, 200, false, "")
		end
	end
end

--Lấy toàn bộ food của player
local function GetAllFoodFromPlayer(player)
    local foodList = {}
    -- Inventory chính
    local inv = player:getInventory()
    Func.GetFoodInContainer(inv, foodList)
    return foodList
end
--Đưa food cho NPC
local function GiveFoodsForQuest(player, qStep, args) --GiveFoodsForQuest(player, qStep, {requestRHunger = 1400})
	local foodList = GetAllFoodFromPlayer(player)
	local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
	if foodList then
		local givenFood = false
		--local requestRHunger = args.requestRHunger
		for _, food in ipairs(foodList) do
			if food then
				if not food:isPoison() and not food:isRotten() and not food:isbDangerousUncooked() then
					local rHunger = 0
					if not playerGMD_Quest_Q1[qStep].collectedRHunger then playerGMD_Quest_Q1[qStep].collectedRHunger = 0 end
					if not playerGMD_Quest_Q1[qStep].requestRHunger then playerGMD_Quest_Q1[qStep].requestRHunger = args.requestRHunger end
					
					rHunger = math.abs(math.floor(food:getHungChange() * 100)) --kết quả: số nguyên dương làm tròn. getHungChange có giá trị -0.xxx...
					if rHunger == 0 then
						local calo = food:getCalories()
						if calo then rHunger = math.floor(food:getCalories() / 15) end					
					end			
					if rHunger > 0 then
						--food:Remove()
						Func.RemoveItemFromContainer(player:getInventory(), food, nil, 1)
						playerGMD_Quest_Q1[qStep].collectedRHunger = playerGMD_Quest_Q1[qStep].collectedRHunger + rHunger
						givenFood = true
					end
					if playerGMD_Quest_Q1[qStep].collectedRHunger >= playerGMD_Quest_Q1[qStep].requestRHunger then
						playerGMD_Quest_Q1[qStep].collectedRHunger = nil
						playerGMD_Quest_Q1[qStep].requestRHunger = nil
						--playerGMD_Quest_Q1[qStep].isAllFoodsCollected = true
						sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
						return "done"
					end
				end
			end
		end
		if givenFood == true then
			sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
			return "update"
		end
	end
end

--Lấy toàn bộ waterSource của player
local function GetAllWaterSourceFromPlayer(player)
    local waterSourceList = {}
    -- Inventory chính
    local inv = player:getInventory()
    Func.GetWaterInContainer(inv, waterSourceList)
    return waterSourceList
end
--Đưa water cho NPC
local function GiveWaterForQuest(player, qStep, args) --GiveWaterForQuest(player, qStep, {requestRThirst = 30})
	local waterSourceList = GetAllWaterSourceFromPlayer(player)
	local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
	if waterSourceList then
		local givenWater = false
		--local requestRThirst = args.requestRThirst
		for _, waterSource in ipairs(waterSourceList) do
			if waterSource then
				local fluidCont = waterSource:getFluidContainer()
				if fluidCont then
					if not fluidCont:isTainted() and (fluidCont:getPrimaryFluid():getFluidTypeString() == "Water" or fluidCont:getPrimaryFluid():getFluidTypeString() == "CarbonatedWater") then
						local rThirst = 0
						if not playerGMD_Quest_Q1[qStep].collectedRThirst then playerGMD_Quest_Q1[qStep].collectedRThirst = 0 end
						if not playerGMD_Quest_Q1[qStep].requestRThirst then playerGMD_Quest_Q1[qStep].requestRThirst = args.requestRThirst end
						
						rThirst = math.floor(fluidCont:getAmount() * 10 + 0.5) / 10 --kết quả: làm tròn 0,1 số thập phân. 0.xxx... -> 0.x
							
						if rThirst > 0 then
							--waterSource:Remove()
							Func.RemoveItemFromContainer(player:getInventory(), waterSource, nil, 1)
							playerGMD_Quest_Q1[qStep].collectedRThirst = playerGMD_Quest_Q1[qStep].collectedRThirst + rThirst
							givenWater = true
						end
						if playerGMD_Quest_Q1[qStep].collectedRThirst >= playerGMD_Quest_Q1[qStep].requestRThirst then
							playerGMD_Quest_Q1[qStep].collectedRThirst = nil
							playerGMD_Quest_Q1[qStep].requestRThirst = nil
							--playerGMD_Quest_Q1[qStep].isAllWaterCollected = true
							sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
							return "done"
						end
					end
				end
			end
		end
		if givenWater == true then
			sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
			return "update"
		end
	end
end

--Lấy toàn bộ ItemType cụ thể trong túi đồ player
local function GetAllItemTypeFromPlayer(player, itemType)
	local itemList = {}
    -- Inventory chính
    local inv = player:getInventory()
	if inv and instanceItem(itemType) then
		Func.GetItemInContainer(inv, itemList, itemType)
		return itemList
	end
    return nil
end

--Đưa Blood Sample cho NPC
local function GiveBloodSampleForQuest(player, qStep, args) --GiveBloodSampleForQuest(player, qStep, {requestBlood = 15})
	local bloodList = GetAllItemTypeFromPlayer(player, "Base.VLZBloodSyringe")
	local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
	if bloodList then
		local givenBlood = false
		for _, bloodSample in ipairs(bloodList) do
			if bloodSample then
				if not playerGMD_Quest_Q1[qStep].collectedBlood then playerGMD_Quest_Q1[qStep].collectedBlood = 0 end
				if not playerGMD_Quest_Q1[qStep].requestBlood then playerGMD_Quest_Q1[qStep].requestBlood = args.requestBlood end
				--bloodSample:Remove()
				Func.RemoveItemFromContainer(player:getInventory(), bloodSample, nil, 1)
				playerGMD_Quest_Q1[qStep].collectedBlood = playerGMD_Quest_Q1[qStep].collectedBlood + 1
				givenBlood = true
				
				if playerGMD_Quest_Q1[qStep].collectedBlood >= playerGMD_Quest_Q1[qStep].requestBlood then
					playerGMD_Quest_Q1[qStep].collectedBlood = nil
					playerGMD_Quest_Q1[qStep].requestBlood = nil
					--playerGMD_Quest_Q1[qStep].isAllBloodCollected = true
					sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
					return "done"
				end
			end
		end
		if givenBlood == true then
			sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
			return "update"
		end
	end
end

--Đưa Mẫu Vật cho NPC
local function GiveZSpecimenForQuest(player, qStep, args) --GiveZSpecimenForQuest(player, qStep, {requestZSpecimen = 15})
	local zSpecimenList = GetAllItemTypeFromPlayer(player, "Base.VLZSpecimenContainer")
	local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
	if zSpecimenList then
		local givenzSpecimen = false
		for _, zSpecimen in ipairs(zSpecimenList) do
			if zSpecimen then
				if not playerGMD_Quest_Q1[qStep].collectedZSpecimen then playerGMD_Quest_Q1[qStep].collectedZSpecimen = 0 end
				if not playerGMD_Quest_Q1[qStep].requestZSpecimen then playerGMD_Quest_Q1[qStep].requestZSpecimen = args.requestZSpecimen end
				--zSpecimen:Remove()
				Func.RemoveItemFromContainer(player:getInventory(), zSpecimen, nil, 1)
				playerGMD_Quest_Q1[qStep].collectedZSpecimen = playerGMD_Quest_Q1[qStep].collectedZSpecimen + 1
				givenzSpecimen = true
				if playerGMD_Quest_Q1[qStep].collectedZSpecimen >= playerGMD_Quest_Q1[qStep].requestZSpecimen then
					playerGMD_Quest_Q1[qStep].collectedZSpecimen = nil
					playerGMD_Quest_Q1[qStep].requestZSpecimen = nil
					--playerGMD_Quest_Q1[qStep].isAllZSpecimenCollected = true
					sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
					return "done"
				end
			end
		end
		if givenzSpecimen == true then
			sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
			return "update"
		end
	end
end

--Đưa Infected Specimen cho NPC
local function GiveInfectedSpecimenForQuest(player, qStep, args) --GiveInfectedSpecimenForQuest(player, qStep, {requestQItem = 2})
	local items = GetAllItemTypeFromPlayer(player, "Base.VLInfectedSpecimenContainer")
	local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
	if items then
		local givenItem = false
		for _, item in ipairs(items) do
			if item then
				if not playerGMD_Quest_Q1[qStep].collectedQItem then playerGMD_Quest_Q1[qStep].collectedQItem = 0 end
				if not playerGMD_Quest_Q1[qStep].requestQItem then playerGMD_Quest_Q1[qStep].requestQItem = args.requestQItem end
				--item:Remove()
				Func.RemoveItemFromContainer(player:getInventory(), item, nil, 1)
				playerGMD_Quest_Q1[qStep].collectedQItem = playerGMD_Quest_Q1[qStep].collectedQItem + 1
				givenItem = true
				if playerGMD_Quest_Q1[qStep].collectedQItem >= playerGMD_Quest_Q1[qStep].requestQItem then
					playerGMD_Quest_Q1[qStep].collectedQItem = nil
					playerGMD_Quest_Q1[qStep].requestQItem = nil
					--playerGMD_Quest_Q1[qStep].isAllZSpecimenCollected = true
					sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
					return "done"
				end
			end
		end
		if givenItem == true then
			sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
			return "update"
		end
	end
end

--Lấy toàn bộ Alcohol trong túi đồ player
local function GetAllAlcoholFromPlayer(player)
    local itemList = {}
    -- Inventory chính
    local inv = player:getInventory()
    Func.GetAlcoholsInContainer(inv, itemList)
    return itemList
end
--Đưa Alcohol cho NPC
local function GiveAlcoholsForQuest(player, qStep, args) --GiveAlcoholsForQuest(player, qStep)
	local alcoholList = GetAllAlcoholFromPlayer(player)
	local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
	if alcoholList and #alcoholList >= 2 then
		local removeAlcohol = 0
		for _, alcohol in ipairs(alcoholList) do
			if alcohol then
				--alcohol:Remove()
				Func.RemoveItemFromContainer(player:getInventory(), alcohol, nil, 1)
				removeAlcohol = removeAlcohol + 1
				if removeAlcohol >= 2 then
					return "done"
				end
			end
		end
	end
	return nil
end

--Đưa Chuột sống cho NPC
local function GiveMousesForQuest(player, qStep, args) --GiveMousesForQuest(player, qStep, {requestMouse = 5})
	local animalList = GetAllItemTypeFromPlayer(player, "Base.Animal")
	local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
	if animalList then
		local givenMouse = false
		for _, animal in ipairs(animalList) do
			if animal and animal:getAnimal() and animal:getAnimal():getAnimalType() and (string.find(animal:getAnimal():getAnimalType(), "rat") or string.find(animal:getAnimal():getAnimalType(), "mouse")) then
				if not playerGMD_Quest_Q1[qStep].collectedMouse then playerGMD_Quest_Q1[qStep].collectedMouse = 0 end
				if not playerGMD_Quest_Q1[qStep].requestMouse then playerGMD_Quest_Q1[qStep].requestMouse = args.requestMouse end
				--animal:Remove()
				Func.RemoveItemFromContainer(player:getInventory(), animal, nil, 1)
				playerGMD_Quest_Q1[qStep].collectedMouse = playerGMD_Quest_Q1[qStep].collectedMouse + 1
				givenMouse = true
				if playerGMD_Quest_Q1[qStep].collectedMouse >= playerGMD_Quest_Q1[qStep].requestMouse then
					playerGMD_Quest_Q1[qStep].collectedMouse = nil
					playerGMD_Quest_Q1[qStep].requestMouse = nil
					--playerGMD_Quest_Q1[qStep].isAllMouseCollected = true
					sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
					return "done"
				end
			end
		end
		if givenMouse == true then
			sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
			return "update"
		end
	end
end

--Đưa Frog còn sống cho NPC
local function GiveFrogsForQuest(player, qStep, args) --GiveFrogsForQuest(player, qStep, {requestFrog = 3})
	local frogList = GetAllItemTypeFromPlayer(player, "Base.Frog")
	local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
	if frogList then
		local givenFrog = false
		for _, frog in ipairs(frogList) do
			if frog then
				if not playerGMD_Quest_Q1[qStep].collectedFrog then playerGMD_Quest_Q1[qStep].collectedFrog = 0 end
				if not playerGMD_Quest_Q1[qStep].requestFrog then playerGMD_Quest_Q1[qStep].requestFrog = args.requestFrog end
				--frog:Remove()
				Func.RemoveItemFromContainer(player:getInventory(), frog, nil, 1)
				playerGMD_Quest_Q1[qStep].collectedFrog = playerGMD_Quest_Q1[qStep].collectedFrog + 1
				givenFrog = true
				if playerGMD_Quest_Q1[qStep].collectedFrog >= playerGMD_Quest_Q1[qStep].requestFrog then
					playerGMD_Quest_Q1[qStep].collectedFrog = nil
					playerGMD_Quest_Q1[qStep].requestFrog = nil
					--playerGMD_Quest_Q1[qStep].isAllFrogCollected = true
					sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
					return "done"
				end
				
			end
		end
		if givenFrog == true then
			sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
			return "update"
		end
	end
end

--Đưa Leech còn sống cho NPC
local function GiveLeechsForQuest(player, qStep, args) --GiveLeechsForQuest(player, qStep, {requestLeech = 10})
	local leechList = GetAllItemTypeFromPlayer(player, "Base.Leech")
	local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
	if leechList then
		local givenLeech = false
		for _, leech in ipairs(leechList) do
			if leech and leech:isbDangerousUncooked() then
				if not playerGMD_Quest_Q1[qStep].collectedLeech then playerGMD_Quest_Q1[qStep].collectedLeech = 0 end
				if not playerGMD_Quest_Q1[qStep].requestLeech then playerGMD_Quest_Q1[qStep].requestLeech = args.requestLeech end
				--leech:Remove()
				Func.RemoveItemFromContainer(player:getInventory(), leech, nil, 1)
				playerGMD_Quest_Q1[qStep].collectedLeech = playerGMD_Quest_Q1[qStep].collectedLeech + 1
				givenLeech = true
				if playerGMD_Quest_Q1[qStep].collectedLeech >= playerGMD_Quest_Q1[qStep].requestLeech then
					playerGMD_Quest_Q1[qStep].collectedLeech = nil
					playerGMD_Quest_Q1[qStep].requestLeech = nil
					--playerGMD_Quest_Q1[qStep].isAllLeechCollected = true
					sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
					return "done"
				end
			end
		end
		if givenLeech == true then
			sendClientCommand(player, 'MainQuest1', 'UpdateAllPlayerGMD', playerGMD_Quest_Q1)
			return "update"
		end
	end
end

--Spawn zombie cho event quest q1s035
local function SpawnLocalZombiesEventq1s035(player, count, args) --SpawnLocalZombiesEventq1s035(player, 100, {minDist = 10, maxDist = 60, z = 0})
	local x, y = player:getX(), player:getY()
	local z = args.z or 0
	local minDist, maxDist = args.minDist or 1, args.maxDist or 10
	if not x or not y then return nil end
	
	local loop = count * 2
	local cnt = 0
	for i = 1, loop do
		--lấy tọa độ x, y cách player tối thiểu minDist
		local _x = ZombRand(2) == 0 and (x + minDist + ZombRand(maxDist - minDist)) or (x - minDist - ZombRand(maxDist - minDist))
		local _y = ZombRand(2) == 0 and (y + minDist + ZombRand(maxDist - minDist)) or (y - minDist - ZombRand(maxDist - minDist))
		local square = getCell():getGridSquare(_x, _y, z)
		--print("Client-----square isOutside() ", square:isOutside(), square:isFree(true))
		if square and square:isOutside() and square:isFree(true) then
			addZombiesInOutfit(_x, _y, 0, 1, "Generic03", 50)
			cnt = cnt + 1
			if cnt >= count then return true end
		end
	end
	return false
end			
		
--Kiểm tra có zombie nằm trong bán kính maxDist, loại trừ NPC
local function CheckZombieExistAroundSquare(square, args) --CheckZombieExistAroundSquare(square, {maxDist = maxDist, sameZ = false})
	--print("Client-----CheckZombieExistAroundSquare-1  ", square, args.maxDist)
	local maxDist = args.maxDist
	local zombieList = Func.GetZombiesAroundSquare(square, {radius = maxDist, sameZ = args.sameZ})
	local npcIDList = Func.GetAllnpcIDSpawning()
	local removeIndex = {}
    for i, zombie in ipairs(zombieList) do
        if zombie then
			--kiểm tra có zombie nào là NPC thì xóa khỏi zombieList
			local zID = Func.GetZombieOnlineIDorUID(zombie)
			for _, npcID in ipairs(npcIDList) do
				if zID == npcID then
					table.insert(removeIndex, i)
					break
				end
			end				
		end
	end
	
	for _, index in ipairs(removeIndex) do
		table.remove(zombieList, index)
	end
	--print("Client-----zombieList-1  ", #zombieList)
	--nếu zombieList vẫn còn zombie sau khi xóa
	if #zombieList > 0 then
		return true
	end
	return false
end

--Khi player tại khu vực phòng thí nghiệm thì Kiểm tra quanh 30 ô còn zombie không 
local function EveryTenMinutes_CheckQuestq1s035()
	local player = getPlayer()
	if player and not player:isDead() then
		if Func.IsPlayerInArea(player, {x1 = 10630, y1 = 10394, x2 = 10651, y2 = 10416}) then
			local square = player:getCurrentSquare()
			if square then
				--nếu 30 ô xung quanh không còn zombie thì quest done
				local isDone = CheckZombieExistAroundSquare(square, {maxDist = 30, sameZ = false})
				--print("Client-----EveryTenMinutes_CheckQuestq1s035  ", isDone)
				if not isDone then
					local pData = Func.GetPlayerModData({qStep = nil})
					pData.events.q1s035 = true
					Events.EveryTenMinutes.Remove(EveryTenMinutes_CheckQuestq1s035)
				end
			end
		end
	end
end
--Events.EveryTenMinutes.Remove(EveryTenMinutes_CheckQuestq1s035)
--Events.EveryTenMinutes.Add(EveryTenMinutes_CheckQuestq1s035)



--NÓI CHUYỆN VỚI NPC
VLF.TalkToNPC["q1s003"] = function(player, square, zNPC, qStep) --phó Hiệu Trưởng
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		if playerGMD_Quest_Q1[qStep].active == true then
			local qStep_Next = CalculateQStepNext(qStep)
			--cập nhật qStep
			DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true})
		end
	end
end

VLF.TalkToNPC["q1s004"] = function(player, square, zNPC, qStep) --cảnh sát viên
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		if playerGMD_Quest_Q1[qStep].active == true then
			local qStep_Next = CalculateQStepNext(qStep)
			DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true})
		end
	end
end

VLF.TalkToNPC["q1s005"] = function(player, square, zNPC, qStep) --Cảnh sát trưởng --NPC biến thành zombie
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		if playerGMD_Quest_Q1[qStep].active == true then
			Func.DelayFunction(function()
				Func.NPCTurnToZombie(player, zNPC, qStep, {isPopUp = true})
			end, 120)
		end
	end
end

VLF.TalkToNPC["q1s007"] = function(player, square, zNPC, qStep) --Tiến sĩ Dr. Doudna
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then
			local qStep_Next = CalculateQStepNext(qStep)
			DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 1})
		end
	end
end

VLF.TalkToNPC["q1s008"] = function(player, square, zNPC, qStep) --Trung úy tại Louisville Metro Police Department
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then
			local qStep_Next = CalculateQStepNext(qStep)
			DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = false, qID = 1})
		end
	end
end

VLF.TalkToNPC["q1s012"] = function(player, square, zNPC, qStep) --Phòng thí nghiệm bí ẩn
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then			
			local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1			
			DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
		end
	end
end

VLF.TalkToNPC["q1s013"] = function(player, square, zNPC, qStep) --Tìm Dr. Bassler
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then
			local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
			Func.DelayFunction(function()
				Func.RemoveNPCQuest(zNPC)
			end, 300)
			DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
			Func.NPCInQueueSpawnList({qStep = "q1s014_2", active = true}) --Thêm NPC thứ 2
		end
	end
end

VLF.TalkToNPC["q1s014"] = function(player, square, zNPC, qStep) --Trở về phòng thí nghiệm Dr. Venter
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then			
			local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
			DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
			UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
		end
	end
end

VLF.TalkToNPC["q1s015"] = function(player, square, zNPC, qStep) --Đồng ý hỗ trợ Dr. Venter
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then			
			local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1			
			DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
			UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
		end
	end
end

VLF.TalkToNPC["q1s016"] = function(player, square, zNPC, qStep) --Yêu cầu tìm Food
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then
			local collection = GiveFoodsForQuest(player, qStep, {requestRHunger = 1400})
			if collection == "done" then
				local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
				DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
				UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
			elseif collection == "update" then Func.QuestUpdatedPopIn()
			else Func.ActiveQuestIntro_Free(getText("IGUI_VLQ_2_Notification1_"..tostring(qStep)), (getCore():getScreenWidth() - 800) / 2, (getCore():getScreenHeight() - 200) / 16, 800, 200, false, "")
			end				
		end
	end
end

VLF.TalkToNPC["q1s017"] = function(player, square, zNPC, qStep) --Yêu cầu tìm Water
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then
			local collection = GiveWaterForQuest(player, qStep, {requestRThirst = 30})
			if collection == "done" then
				local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
				DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
				UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
				--nhận 2 Empty Syringe Pack
				local inv = player:getInventory()
				if inv then
					--inv:AddItem("Base.VLEmptySyringePack")
					--inv:AddItem("Base.VLEmptySyringePack")
					Func.AddItemToContainer(inv, nil, "Base.VLEmptySyringePack", 2)
				end
			elseif collection == "update" then Func.QuestUpdatedPopIn()
			else Func.ActiveQuestIntro_Free(getText("IGUI_VLQ_2_Notification1_"..tostring(qStep)), (getCore():getScreenWidth() - 800) / 2, (getCore():getScreenHeight() - 200) / 16, 800, 200, false, "")
			end				
		end
	end
end

VLF.TalkToNPC["q1s018"] = function(player, square, zNPC, qStep) --Yêu cầu lấy mẫu máu zombie
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then
			local collection = GiveBloodSampleForQuest(player, qStep, {requestBlood = 15})			
			if collection == "done" then
				local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
				DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
				UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
				Events.OnPreFillWorldObjectContextMenu.Remove(VLF.AddContextMenu_BloodSample)
			elseif collection == "update" then Func.QuestUpdatedPopIn()
			else Func.ActiveQuestIntro_Free(getText("IGUI_VLQ_2_Notification1_"..tostring(qStep)), (getCore():getScreenWidth() - 800) / 2, (getCore():getScreenHeight() - 200) / 16, 800, 200, false, "")
			end				
		end
	end
end

VLF.TalkToNPC["q1s019"] = function(player, square, zNPC, qStep) --chờ 1 ngày
	if qStep then	
		WaitQuestActiveWhenNPCTalk(player, square, zNPC, qStep)
	end
end

VLF.TalkToNPC["q1s020"] = function(player, square, zNPC, qStep) --trở lại phòng thí nghiệm
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then			
			local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
			DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
			UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
			--nhận 2 Empty Specimen Container Pack và Scalpel
			local inv = player:getInventory()
			if inv then
				--inv:AddItem("Base.Scalpel")
				--inv:AddItem("Base.VLEmptySpecimenContainerPack")
				--inv:AddItem("Base.VLEmptySpecimenContainerPack")
				Func.AddItemToContainer(inv, nil, "Base.Scalpel", 1)
				Func.AddItemToContainer(inv, nil, "Base.VLEmptySpecimenContainerPack", 2)
			end
		end
	end
end

VLF.TalkToNPC["q1s021"] = function(player, square, zNPC, qStep) --yêu cầu lấy mẫu vật zombie
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then
			local collection = GiveZSpecimenForQuest(player, qStep, {requestZSpecimen = 15})		
			if collection == "done" then
				local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
				DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
				UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
				Events.OnPreFillWorldObjectContextMenu.Remove(VLF.AddContextMenu_ZombieSpecimen)
				--NPC đưa phần thưởng Strength-enhancing Serum
				local inv = player:getInventory()
				if inv then
					--inv:AddItem("Base.VLUpgradeStrengthSerum1")
					Func.AddItemToContainer(inv, nil, "Base.VLUpgradeStrengthSerum1", 1)
				end
			elseif collection == "update" then Func.QuestUpdatedPopIn()
			else Func.ActiveQuestIntro_Free(getText("IGUI_VLQ_2_Notification1_"..tostring(qStep)), (getCore():getScreenWidth() - 800) / 2, (getCore():getScreenHeight() - 200) / 16, 800, 200, false, "")
			end				
		end
	end
end

VLF.TalkToNPC["q1s022"] = function(player, square, zNPC, qStep) --chờ 1 ngày
	if qStep then
		WaitQuestActiveWhenNPCTalk(player, square, zNPC, qStep)
	end
end

VLF.TalkToNPC["q1s023"] = function(player, square, zNPC, qStep) --Uống rượu cùng người bạn vong niên
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then
			local collection = GiveAlcoholsForQuest(player, qStep)	
			if collection == "done" then
				local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
				DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
				UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
			else Func.ActiveQuestIntro_Free(getText("IGUI_VLQ_2_Notification1_"..tostring(qStep)), (getCore():getScreenWidth() - 800) / 2, (getCore():getScreenHeight() - 200) / 16, 800, 200, false, "")
			end				
		end
	end
end

VLF.TalkToNPC["q1s024"] = function(player, square, zNPC, qStep) --chờ 3 ngày
	if qStep and zNPC and player then	
		WaitQuestActiveWhenNPCTalk(player, square, zNPC, qStep)
	end
end

VLF.TalkToNPC["q1s025"] = function(player, square, zNPC, qStep) --trở lại phòng thí nghiệm
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then			
			local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
			DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
			UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
		end
	end
end

VLF.TalkToNPC["q1s026"] = function(player, square, zNPC, qStep) --yêu cầu bắt 5 con chuột
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then
			local collection = GiveMousesForQuest(player, qStep, {requestMouse = 5})	
			if collection == "done" then
				local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
				DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
				UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
			elseif collection == "update" then Func.QuestUpdatedPopIn()
			else Func.ActiveQuestIntro_Free(getText("IGUI_VLQ_2_Notification1_"..tostring(qStep)), (getCore():getScreenWidth() - 800) / 2, (getCore():getScreenHeight() - 200) / 16, 800, 200, false, "")
			end				
		end
	end
end

VLF.TalkToNPC["q1s027"] = function(player, square, zNPC, qStep) --yêu cầu bắt 3 con Ếch
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then
			local collection = GiveFrogsForQuest(player, qStep, {requestFrog = 3})	
			if collection == "done" then
				local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
				DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
				UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
			elseif collection == "update" then Func.QuestUpdatedPopIn()
			else Func.ActiveQuestIntro_Free(getText("IGUI_VLQ_2_Notification1_"..tostring(qStep)), (getCore():getScreenWidth() - 800) / 2, (getCore():getScreenHeight() - 200) / 16, 800, 200, false, "")
			end				
		end
	end
end

VLF.TalkToNPC["q1s028"] = function(player, square, zNPC, qStep) --yêu cầu bắt 10 con Đỉa
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then
			local collection = GiveLeechsForQuest(player, qStep, {requestLeech = 10})
			if collection == "done" then
				local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
				DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
				UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
			elseif collection == "update" then Func.QuestUpdatedPopIn()
			else Func.ActiveQuestIntro_Free(getText("IGUI_VLQ_2_Notification1_"..tostring(qStep)), (getCore():getScreenWidth() - 800) / 2, (getCore():getScreenHeight() - 200) / 16, 800, 200, false, "")
			end				
		end
	end
end

VLF.TalkToNPC["q1s029"] = function(player, square, zNPC, qStep) --chờ 3 ngày
	if qStep and zNPC and player then	
		WaitQuestActiveWhenNPCTalk(player, square, zNPC, qStep)
	end
end

VLF.TalkToNPC["q1s030"] = function(player, square, zNPC, qStep) --trở lại phòng thí nghiệm
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then			
			local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
			DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
			UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
		end
	end
end

VLF.TalkToNPC["q1s031"] = function(player, square, zNPC, qStep) --yêu cầu tìm Food --1500 hunger
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then
			local collection = GiveFoodsForQuest(player, qStep, {requestRHunger = 1500})
			if collection == "done" then
				local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
				DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
				UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
				--nhận Empty Specimen Container Pack và Scalpel
				local inv = player:getInventory()
				if inv then
					--inv:AddItem("Base.Scalpel")
					--inv:AddItem("Base.VLEmptySpecimenContainerPack")
					Func.AddItemToContainer(inv, nil, "Base.Scalpel", 1)
					Func.AddItemToContainer(inv, nil, "Base.VLEmptySpecimenContainerPack", 1)
				end
			elseif collection == "update" then Func.QuestUpdatedPopIn()
			else Func.ActiveQuestIntro_Free(getText("IGUI_VLQ_2_Notification1_"..tostring(qStep)), (getCore():getScreenWidth() - 800) / 2, (getCore():getScreenHeight() - 200) / 16, 800, 200, false, "")
			end				
		end
	end
end

VLF.TalkToNPC["q1s032"] = function(player, square, zNPC, qStep) --yêu cầu lấy mẫu vật người đang bị biến đổi
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then
			local collection = GiveInfectedSpecimenForQuest(player, qStep, {requestQItem = 2})
			if collection == "done" then
				local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
				DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
				UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
			elseif collection == "update" then Func.QuestUpdatedPopIn()
			else Func.ActiveQuestIntro_Free(getText("IGUI_VLQ_2_Notification1_"..tostring(qStep)), (getCore():getScreenWidth() - 800) / 2, (getCore():getScreenHeight() - 200) / 16, 800, 200, false, "")
			end
		end
	end
end

VLF.TalkToNPC["q1s033"] = function(player, square, zNPC, qStep) --chờ 7 ngày
	if qStep and zNPC and player then	
		WaitQuestActiveWhenNPCTalk(player, square, zNPC, qStep)
	end
end

VLF.TalkToNPC["q1s034"] = function(player, square, zNPC, qStep) --trở lại phòng thí nghiệm
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then			
			local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
			DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
			UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
		end
	end
end

local activeEvent
VLF.TalkToNPC["q1s035"] = function(player, square, zNPC, qStep) --Xác nhận bắt đầu tiêu hủy mẫu vật sống
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then
			if not activeEvent then
				Func.ActiveQuestIntro_Centre(getText("IGUI_VLQ_2_NPCTalk_"..tostring(qStep)), 800, 500, false, "")
				--spawn lẻ 1 zombie để đảm bảo có 1 zombie xung quanh điểm check
				--addZombiesInOutfit(10650, 10406, 0, 1, "Generic03", 50)
				
				--spawn local zombie trong khoảng cách 10 - 60
				if not playerGMD_Quest_Q1.q1s035_2 then playerGMD_Quest_Q1.q1s035_2 = {} end
				local doSpwn = false
				if Func.IsMultiplayerMode() or not playerGMD_Quest_Q1.q1s035_2.active then --multi thì active lại spawn, single player thì chỉ spawn 1 lần
					doSpwn = true
				end
				if doSpwn == true then
					SpawnLocalZombiesEventq1s035(player, 100, {minDist = 10, maxDist = 60, z = 0})
					SpawnLocalZombiesEventq1s035(player, 30, {minDist = 10, maxDist = 40, z = 0})				
					SpawnLocalZombiesEventq1s035(player, 20, {minDist = 10, maxDist = 30, z = 0})
					Func.DelayFunction(function()
						Func.PlaySound(player, "vl_zombiehorder1")
					end, 180) --~5s
				end
				--Add sound thu hút zombie
				Func.DelayFunction(function()
					local sq = getCell():getGridSquare(10642, 10413, 0)
					if sq then addSound(sq:getFloor(), sq:getX(), sq:getY(), sq:getZ(), 250, 1000) end
				end, 20)
				--Chạy event kiểm tra quest hoàn thành chưa
				Func.DelayFunction(function()
					Events.EveryTenMinutes.Remove(EveryTenMinutes_CheckQuestq1s035)
					Events.EveryTenMinutes.Add(EveryTenMinutes_CheckQuestq1s035)
				end, 1800) --~30s
				activeEvent = true
				--cập nhật thông tin quest trong bảng và trên màn hình
				
				playerGMD_Quest_Q1.q1s035_2.active = true		
				Func.QuestUpdatedPopIn()	
			else
				Func.ActiveQuestIntro_Free(getText("IGUI_VLQ_2_Notification1_"..tostring(qStep)), (getCore():getScreenWidth() - 800) / 2, (getCore():getScreenHeight() - 200) / 16, 800, 200, false, "")
			end
		end
	end
end

VLF.TalkToNPC["q1s036"] = function(player, square, zNPC, qStep) --trở lại phòng thí nghiệm
	if qStep then	
		local playerGMD_Quest_Q1 = Func.GetPlayerGlobalModDataQ1(player, {qStep = qStep})
		--print("Client-----------VLF.TalkToNPC["..tostring(qStep).."]= ", player, zNPC, qStep)
		if playerGMD_Quest_Q1[qStep].active == true then			
			local qStep_Next = CalculateQStepNext(qStep) --qStep_Next = qStep + 1
			DoQuestStepActive(player, {npcTalk = true, isPopIn = true, qStep = qStep, active = "done", qStep_Next = qStep_Next, active_Next = true, isNPC_Next = true, qID = 2}) --cập nhật qStep --kiểm tra bắt buộc isNPC_Next
			UpdateNPCToNextQStep(zNPC, qStep_Next) --cập nhật NPC thành NPC qStep tiếp theo
		end
	end
end

VLF.TalkToNPC["q1s037"] = function(player, square, zNPC, qStep) --chờ 2 ngày
	if qStep and zNPC and player then	
		WaitQuestActiveWhenNPCTalk(player, square, zNPC, qStep)
	end
end

