require "TimedActions/ISBaseTimedAction"
require "vl_quest_utils"

VL_ISTakeZombieSpecimen = ISBaseTimedAction:derive("VL_ISTakeZombieSpecimen")

local AddItemToContainer = VLF.AddItemToContainer
local RemoveItemFromContainer = VLF.RemoveItemFromContainer

function VL_ISTakeZombieSpecimen:isValid()
	if not self.character:getInventory():FindAndReturn("Base.Scalpel") or not self.character:getInventory():FindAndReturn("Base.VLEmptySpecimenContainer") then
		return false
	end
	
	return true
end

function VL_ISTakeZombieSpecimen:waitToStart()
	self.character:faceThisObject(self.zombie)
	return self.character:shouldBeTurning()
end

function VL_ISTakeZombieSpecimen:update()
	if not self.zombie:getActionStateName() == "onground" then
		self:stop()
	end
	self.character:faceThisObject(self.zombie)
	self.character:setMetabolicTarget(Metabolics.MediumWork)
end

function VL_ISTakeZombieSpecimen:start()
	self:setActionAnim("Loot")
	self.character:SetVariable("LootPosition", "Low")
	local priHandItem = instanceItem("Base.Scalpel")
	if priHandItem then self:setOverrideHandModels(priHandItem, nil)
	else self:setOverrideHandModels(nil, nil)
	end	
	self.character:reportEvent("TakeZombieSpecimen")
end

function VL_ISTakeZombieSpecimen:stop()
	ISBaseTimedAction.stop(self)
end

function VL_ISTakeZombieSpecimen:perform()
	ISInventoryPage.renderDirty = true
	-- needed to remove from queue / start next.
	ISBaseTimedAction.perform(self)
end

function VL_ISTakeZombieSpecimen:complete()
	AddItemToContainer(self.character:getInventory(), nil, "Base.VLZSpecimenContainer", 1)
	--self.character:getInventory():Remove(self.character:getInventory():getFirstType("Base.VLEmptySpecimenContainer"))
	RemoveItemFromContainer(self.character:getInventory(), nil, "Base.VLEmptySpecimenContainer", 1)
	local cData = self.zombie:getModData()
	if not cData.takenZombieSpecimen then
		cData.takenZombieSpecimen = true
		self.zombie:transmitModData()
	end
    return true
end

function VL_ISTakeZombieSpecimen:new(character, zombie, time)
    local o = {}
    setmetatable(o, self)
    self.__index = self
	o.character = character;
    --o.corpseSquare = corpse:getSquare()
	--o.corpseItem = corpse:getItem()
	o.zombie = zombie
    o.stopOnWalk = true
    o.stopOnRun = true
    o.caloriesModifier = 8
    o.maxTime = time
	o.forceProgressBar = true;
	if character:isTimedActionInstant() then
        o.maxTime = 1
    end
    return o
end

