require "TimedActions/ISBaseTimedAction"
require "vl_quest_utils"

VL_ISTakeBloodSample = ISBaseTimedAction:derive("VL_ISTakeBloodSample")

local AddItemToContainer = VLF.AddItemToContainer
local RemoveItemFromContainer = VLF.RemoveItemFromContainer

function VL_ISTakeBloodSample:isValid()
	if not self.character:getInventory():FindAndReturn("Base.VLEmptySyringe") then
		return false
	end
	
	return true
end

function VL_ISTakeBloodSample:waitToStart()
	self.character:faceThisObject(self.corpse)
	return self.character:shouldBeTurning()
end

function VL_ISTakeBloodSample:update()
	--self.corpseItem:setJobDelta(self:getJobDelta());
	self.character:faceThisObject(self.corpse)
	self.character:setMetabolicTarget(Metabolics.MediumWork)
end

function VL_ISTakeBloodSample:start()
	self:setActionAnim("Loot")
	self.character:SetVariable("LootPosition", "Low")
	self:setOverrideHandModels(nil, nil)
	self.character:reportEvent("TakeBloodSample")
end

function VL_ISTakeBloodSample:stop()
	ISBaseTimedAction.stop(self)
end

function VL_ISTakeBloodSample:perform()
	ISInventoryPage.renderDirty = true
	-- needed to remove from queue / start next.
	ISBaseTimedAction.perform(self)
end

function VL_ISTakeBloodSample:complete()
	AddItemToContainer(self.character:getInventory(), nil, "Base.VLZBloodSyringe", 1)
	--self.character:getInventory():Remove(self.character:getInventory():getFirstType("Base.VLEmptySyringe"))
	RemoveItemFromContainer(self.character:getInventory(), nil, "Base.VLEmptySyringe", 1)
	
	local cData = self.corpse:getModData()
	if not cData.takenBloodSample then
		cData.takenBloodSample = true
		self.corpse:transmitModData()
	end
    return true
end

function VL_ISTakeBloodSample:new(character, corpse, time)
    local o = {}
    setmetatable(o, self)
    self.__index = self
	o.character = character;
    --o.corpseSquare = corpse:getSquare()
	o.corpseItem = corpse:getItem()
	o.corpse = corpse
    o.stopOnWalk = true
    o.stopOnRun = true
    o.caloriesModifier = 8
	--o.started = false;
    o.maxTime = time
	o.forceProgressBar = true;
	if character:isTimedActionInstant() then
        o.maxTime = 1
    end
    return o
end


