--HIỆN POPUP THÔNG BÁO NHIỆM VỤ HOÀN THÀNH hoặc CẬP NHẬT BƯỚC MỚI MỖI KHI XONG 1 PHẦN NHIỆM VỤ
--CALL FUNCTION: VLF.QuestUpdatedPopIn()

require "ISUI/ISPanelJoypad"
require "vl_quest_utils"
require "questui/vl_quest_list_ui"

VL_Quest_PopUp_UI = ISPanel:derive("VL_Quest_PopUp_UI")
VLF = VLF or {}

local PlaySound = VLF.PlaySound
local DelayFunction = VLF.DelayFunction
local VLF_QuestUI = VLF.QuestUI

function VL_Quest_PopUp_UI:createChildren()
    DelayFunction(function()
        self:close()
    end, 240) -- ~4s
	
	DelayFunction(function()
		--refresh các thông tin hiển thị trên bảng quest và quest text trên màn hình
		VLF_QuestUI.UpdateQuestListDisplay()
    end, 60) -- ~1s
	
	ISPanel.createChildren(self)
end

function VL_Quest_PopUp_UI:prerender()
    if not self.imageBackground then
		local texture = getTexture("media/ui/background250x100.png")
        if texture then
            self.imageBackground = self:drawTextureScaled(texture, 0, 0, self.width, self.height, 1)
        end
    end

    if not self.imageOnBgr then
		local texture = getTexture("media/ui/spiffo_bw1.png")
        if texture then
            self.imageOnBgr = self:drawTextureScaled(texture, 115, 0, 140, 100, 0.2)
        end
    end

    if not self.iconOnBgr then
		local texture = getTexture("media/ui/questicon_128.png")
        if texture then
            self.iconOnBgr = self:drawTextureScaled(texture, 3, 7, 95, 95, 0.6)
        end
    end
	
    if not self.textOnWindow then
		self.textOnWindow = ISLabel:new(105, 45, 10, getText("IGUI_VLQ_Updated"), 0.5529, 0.9373, 0.6549, 1, UIFont.Medium, true)
		self:addChild(self.textOnWindow)
    end
end

function VL_Quest_PopUp_UI:render()
	ISPanel.render(self)
	
	self:drawRectBorder(0, 0, self.width, self.height, 1, 1, 1, 1)
end

function VL_Quest_PopUp_UI:close()
	self:setVisible(false)
	self:removeFromUIManager()
end

function VL_Quest_PopUp_UI:new(character)
	local width = 250
	local height = 100
    local playerNum = character:getPlayerNum()
	
	--Góc dưới bên phải màn hình
    --local x = getPlayerScreenWidth(playerNum) - width
    --local y = getPlayerScreenHeight(playerNum) - height
	--Ở giữa phía trên màn hình
    local x = (getPlayerScreenWidth(playerNum)/2) - (width/2)
    local y = getPlayerScreenHeight(playerNum)/25
	local o = ISPanel.new(self, x, y, width, height)

	o.width = width
	o.height = height
	o.chr = character
    o.playerNum = playerNum
	o.moveWithMouse = false
	o.anchorRight = true
	o.anchorBottom = true
    o.keepOnScreen = true
	return o
end

-------------------------------------------------------
-- CALL ĐỂ POP UP XUẤT HIỆN
function VLF.QuestUpdatedPopIn()
    local character = getPlayer()
    local popIn = VL_Quest_PopUp_UI:new(character)
    popIn:initialise()
    popIn:addToUIManager()
    PlaySound(character, "questcompleted_1")
end