--CỬA SỔ CHI TIẾT TẤT CẢ NHIỆM VỤ
--CALL FUNCTION: VLF_QuestUI.OpenQuestWindow()

require "ISUI/ISPanelJoypad"
require "vl_quest_utils"

VL_Quest_List_UI = ISCollapsableWindow:derive("VL_Quest_List_UI")

VLF = VLF or {}
VLF.QuestUI = VLF.QuestUI or {}
local VLF_QuestUI = VLF.QuestUI
VLF_QuestUI.IsShowOnScreen = VLF_QuestUI.IsShowOnScreen or {}
VLF_QuestUI.ItemsAdded = nil

VLF.QuestListShowOnUI = VLF.QuestListShowOnUI or {} 
--VLF.QuestListShowOnUI["Q1"] = {id = 1, qStep = "q1s003", isDone = false, qtype = getText("IGUI_VLQ_MainQuest"), isCollection = false, currentCollection = nil, requestCollection = nil, name = getText("IGUI_VLQ_Main_1_Name"), task = getText("IGUI_VLQ_Main_1_Task_q1s003"), desc = getText("IGUI_VLQ_Main_1_Desc_q1s003")}
--VLF.QuestListShowOnUI["Q2"] = {id = 2, qStep = 1, isDone = false, qtype = getText("IGUI_VLQ_MainQuest"), isCollection = true, currentCollection = 0, requestCollection = 1, name = "111111111111", task = "2222222222222222", desc = getText("IGUI_VLQ_Main_1_Desc_1")}
--VLF.QuestListShowOnUI["Q3"] = {id = 3, qStep = 1, isDone = false, qtype = getText("IGUI_VLQ_MainQuest"), isCollection = true, currentCollection = 0, requestCollection = 1, name = "111111111111", task = "2222222222222222", desc = getText("IGUI_VLQ_Main_1_Desc_1")}

local SplitTextByLength = VLF.SplitTextByLength

local fontHeightSmall = getTextManager():getFontHeight(UIFont.Small)
local fontHeightMedium = getTextManager():getFontHeight(UIFont.Medium)
local fontHeightLarge = getTextManager():getFontHeight(UIFont.Large)

function VL_Quest_List_UI:createChildren()
    ISCollapsableWindow.createChildren(self)
end

function VL_Quest_List_UI:prerender()
    ISCollapsableWindow.prerender(self)
    self:drawTextCentre(getText("IGUI_VLQ_TitleUI"), self.width / 2, 0, 1, 1, 1, 1, UIFont.Small)
    self:drawTextCentre(getText("IGUI_VLQ_TipShowQuestScreen"), self.width / 2, fontHeightSmall, 1, 1, 1, 0.9, UIFont.Small)
    self:drawTextCentre(getText("IGUI_VLQ_TipShowQuestScreen_2"), self.width / 2, self.height - (fontHeightSmall * 1.3)  , 1, 1, 1, 0.9, UIFont.Small)
end

function VL_Quest_List_UI:render()
    ISCollapsableWindow.render(self)
end

function VL_Quest_List_UI:close()
    self:setVisible(false)
    self:removeFromUIManager()
    VLF_QuestUI.window = nil
end

--Close khi ấn ESC
function VL_Quest_List_UI:onKeyPress(key)
    if key == Keyboard.KEY_ESCAPE then
        self:close()
    end
end

function VL_Quest_List_UI:new(character, width, height)
    --local width, height = 800, 700
    local playerNum = character:getPlayerNum()
    local x = (getPlayerScreenWidth(playerNum) / 2) - (width / 2)
    local y = (getPlayerScreenHeight(playerNum) / 2) - (height / 2)

    local o = ISCollapsableWindow.new(self, x, y, width, height)
    o.chr = character
    o.playerNum = playerNum
    o.moveWithMouse = true
    o.anchorLeft = true
    o.anchorRight = true
    o.anchorTop = true
    o.anchorBottom = true
    o.resizable = false
    o:setWantKeyEvents(true)
    return o
end

function VL_Quest_List_UI:initialise()
    ISCollapsableWindow.initialise(self)
    
        --Khởi tạo khu vực trong UI có thể scroll chuột
    local btnHgt = fontHeightSmall + 2
    local y = fontHeightSmall * 2

    self.questList = ISScrollingListBox:new(10, y, self.width - 20, self.height - (5 + btnHgt + 5) - y)
    self.questList:initialise()
    self.questList:instantiate()
    self.questList.itemheight = 216
    self.questList.selected = 0
    self.questList.joypadParent = self
    self.questList.font = UIFont.NewSmall
    self.questList.doDrawItem = self.drawQuestItem
    self.questList.drawBorder = true
    self:addChild(self.questList)
    
    VLF_QuestUI.ItemsAdded = self.questList.items
    --onMouseDoubleClick
    function self.questList:onMouseDoubleClick(x, y)
        -- Gọi lại hành vi gốc để cập nhật self.selected
        ISScrollingListBox.onMouseDoubleClick(self, x, y)
        if self.selected > 0 then
            local item = self.items[self.selected]
            if item.item and item.item.id then
                local qid = item.item.id
                if not VLF_QuestUI.IsShowOnScreen[qid] then
                    VLF_QuestUI.IsShowOnScreen[qid] = true
                    Events.OnPostUIDraw.Remove(VLF.DrawUIInfoQuest)
                    Events.OnPostUIDraw.Add(VLF.DrawUIInfoQuest)
                else
                    VLF_QuestUI.IsShowOnScreen[qid] = false
                end
            end
        end
    end
    ------------------------------------------------------------------
    --Add các item text, mỗi dòng ở đây sẽ được draw bằng VL_Quest_List_UI:drawQuestItem
    for text, itemData in pairs(VLF.QuestListShowOnUI) do
        if text and itemData then
            self.questList:addItem(text, itemData)
        end
    end
    --self.questList:addItem("q1", { id = 1, qStep = qData.qStep, isDone = qData.isDone, qtype = getText("IGUI_VLQ_MainQuest"), isCollection = qData.isCollection, currentCollection = qData.currentCollection, requestCollection = qData.requestCollection, name = getText("IGUI_VLQ_Main_1_Name"), task = getText("IGUI_VLQ_Main_1_Task_" .. tostring(qData.qStep)), desc = getText("IGUI_VLQ_Main_1_Desc_" .. tostring(qData.step))})
end

--DRAW TẤT CẢ CÁC ITEM Ở addItem
function VL_Quest_List_UI:drawQuestItem(y, item, alt)
    local a = 0.8
    local xOffset = 40
    local yOffset = y + 10
    local qData = item.item
    local itemHeight = self.itemheight
    
    --XỬ LÝ TEXT
    --Thay văn bản thuần <LINE> thành ký tự ASCII 10 \n để nhận dạng lệnh xuống dòng
    local text = qData.desc:gsub("<LINE>", "\n")

    --Chia dòng theo \n
    local lines = {}
    for line in text:gmatch("([^\n]+)") do
        table.insert(lines, line)
    end
    
    --Chia dòng khi vượt quá giới hạn ký tự
    local _lines = {}
    for _,line in ipairs(lines) do         
        local result = SplitTextByLength(line, self.width * 0.94, UIFont.NewSmall) --730
        for i, l in ipairs(result) do
            table.insert(_lines, l)
        end
    end
    
    --Tăng chiều cao cho border nếu có nhiều dòng text
    if #_lines > 1 then
        local i = #_lines - 1
        itemHeight = itemHeight + i * fontHeightSmall
    end
    
    --Vẽ đường viền mỗi ô
    self:drawRectBorder(0, (y), self:getWidth(), itemHeight - 1, a, self.borderColor.r, self.borderColor.g, self.borderColor.b)
    if self.selected == item.index then
        self:drawRect(0, (y), self:getWidth(), itemHeight - 1, 1, 0.17647, 0.26667, 0.26667)
    end

    -- VẼ MÔ TẢ NHIỆM VỤ
    --Tên nhiệm vụ
    local r, g, b = 0.8, 0.8, 0.8
    self:drawTextCentre(qData.name, self.width / 2, yOffset, 0.5529, 0.9373, 0.6549, 1, UIFont.NewLarge)
    
    --Yêu cầu nhiệm vụ
    yOffset = yOffset + fontHeightLarge
    self:drawTextCentre(qData.task, self.width / 2, yOffset, 0.7765, 0.4275, 0.5176, 1, UIFont.NewMedium)
    
    --Thể loại nhiệm vụ
    yOffset = yOffset + fontHeightMedium
    --self:drawText(getText("IGUI_VLQ_QuestTypeTitle") .. qData.qtype, xOffset, yOffset, 0.98, 0.98, 0.98, 1, UIFont.Small)
    self:drawText(getText("IGUI_VLQ_QuestTypeTitle"), xOffset, yOffset, 0.98, 0.98, 0.98, 1, UIFont.Small)
    self:drawText(qData.qtype, xOffset + getTextManager():MeasureStringX(UIFont.Small, getText("IGUI_VLQ_QuestTypeTitle")), yOffset, 0.5529, 0.9373, 0.6549, a, UIFont.Small)
    
    --Tiến trình nhiệm vụ
    yOffset = yOffset + fontHeightSmall
    self:drawText(getText("IGUI_VLQ_ProgressTitle"), xOffset, yOffset, 0.98, 0.98, 0.98, 1, UIFont.Small)
    if qData.isDone == true then
        self:drawText(getText("IGUI_VLQ_Completed") .. " (" .. tostring(string.sub(qData.qStep, -2)) .. ")", xOffset + getTextManager():MeasureStringX(UIFont.Small, getText("IGUI_VLQ_ProgressTitle")), yOffset, 0.5529, 0.9373, 0.6549, 1, UIFont.Small)
    else
        if qData.isCollection == true then
            --nếu có tên của quest item
            if qData.collectQItemName then 
                self:drawText(" "..tostring(qData.collectQItemName).." - "..tostring(qData.currentCollection) .. "/" ..tostring(qData.requestCollection).."  (" .. tostring(tonumber(string.sub(qData.qStep, -3)))  .. ")" , xOffset + getTextManager():MeasureStringX(UIFont.Small, getText("IGUI_VLQ_ProgressTitle")), yOffset, 0.9608, 0.9608, 0.6353, a, UIFont.Small)
            else
                self:drawText(" "..tostring(qData.currentCollection) .. "/" ..tostring(qData.requestCollection).." (" .. tostring(tonumber(string.sub(qData.qStep, -3)))  .. ")" , xOffset + getTextManager():MeasureStringX(UIFont.Small, getText("IGUI_VLQ_ProgressTitle")), yOffset, 0.9608, 0.9608, 0.6353, a, UIFont.Small)
            end
        else
            self:drawText(getText("IGUI_VLQ_InProgress") .. " (" .. tostring(tonumber(string.sub(qData.qStep, -3))) .. ")", xOffset + getTextManager():MeasureStringX(UIFont.Small, getText("IGUI_VLQ_ProgressTitle")), yOffset, 0.9608, 0.9608, 0.6353, a, UIFont.Small)
        end        
    end
    
    --Nội dung nhiệm vụ
    yOffset = yOffset + fontHeightSmall + 5
    self:drawText(getText("IGUI_VLQ_Description"), xOffset, yOffset, 0.98, 0.98, 0.98, 1, UIFont.Small)
    yOffset = yOffset + fontHeightSmall
    --Vẽ text
    for i,line in ipairs(_lines) do
        self:drawText(line, xOffset-20, yOffset, r, g, b, a, UIFont.Small)
        yOffset = yOffset + fontHeightSmall
    end    

    return y + itemHeight
end

--CALL
function VLF_QuestUI.OpenQuestWindow()
    if not VLF_QuestUI.window then
        VLF_QuestUI.window = VL_Quest_List_UI:new(getPlayer(), 800, 700)
        VLF_QuestUI.window:initialise()
        VLF_QuestUI.window:addToUIManager()
    else
        VLF_QuestUI.window:close()
    end
end

--CALL ĐỂ UPDATE HIỂN THỊ TRONG BẢNG QUEST VÀ TEXT QUEST TRÊN MÀN HÌNH --cần delay 1 lúc để VLF_QuestUI.ItemsAdded cập nhật
function VLF_QuestUI.UpdateQuestListDisplay()
    --print("Client-----------UpdateQuestListDisplay= ")
    if not VLF_QuestUI.window then
        VLF_QuestUI.window = VL_Quest_List_UI:new(getPlayer(), 800, 700)
        VLF_QuestUI.window:initialise()
        VLF_QuestUI.window:addToUIManager()
        VLF_QuestUI.window:close()
    else
        VLF_QuestUI.window:close()
        VLF_QuestUI.window = VL_Quest_List_UI:new(getPlayer(), 800, 700)
        VLF_QuestUI.window:initialise()
        VLF_QuestUI.window:addToUIManager()
    end    
end

-----------------------------------------------------------------------
--UI NÚT BẤM QUEST LIST Ở MAIN MENU KHI ESC
local mainScreenInstantiate = MainScreen.instantiate
local OpenQuestWindow = VLF_QuestUI.OpenQuestWindow
--Tạo nút bấm ở Main Menu
function MainScreen:instantiate()
    mainScreenInstantiate(self)

    local mainScreen = MainScreenState.getInstance();
	if mainScreen ~= nil and (ISDemoPopup.instance == nil) then
        if getPlayer() then
            local playerNum = getPlayer():getPlayerNum()
            local width = 130
            local height = 60
            local x = getPlayerScreenWidth(playerNum)*0.9
            local y = getPlayerScreenHeight(playerNum)/2

            local questListButton = ISButton:new(x, y, width, height, getText("IGUI_VLQ_TitleUI"), self, OpenQuestWindow)
            self:addChild(questListButton)
        end
	end
end






