--ICON NHIỆM VỤ HIỂN THỊ TRÊN MÀN HÌNH - NÚT BẤM ĐỂ MỞ BẢNG THÔNG TIN NHIỆM VỤ
--Tự tạo khi nhân vật đăng nhập

require "ISUI/ISUIElement"
require "questui/vl_quest_list_ui"

VL_Quest_Button_UI = ISPanel:derive("VL_Quest_Button_UI")
VLF = VLF or {}
VLF.questPanelData = nil

local OpenQuestWindow = VLF.QuestUI.OpenQuestWindow
local width = getCore():getScreenWidth()

local function setSize()
    local size = 48
    if width > 3000 then size = 80
	elseif width > 2100 then size = 64
	else
		size = 48
    end
    return size
end

function VL_Quest_Button_UI:new(playerIndex,player,enabled)
	local bWidth = setSize()
	local bHeight = bWidth
	local panelData = {}
	panelData = ISPanel:new(getCore():getScreenWidth()/23, getCore():getScreenHeight()/7, bWidth, bHeight)
	setmetatable(panelData, self)
	self.__index = self
	
	panelData.playerIndex = playerIndex
	panelData.player = player
	panelData.player_isDead = false
	panelData.infopanel = getPlayerInfoPanel(player:getPlayerNum())
	panelData.moveWithMouse = true
	panelData.rightMouseDown = false
	panelData.dragging = false
    panelData.settingsPanel = nil
	panelData.enabled = enabled
	panelData:setVisible(enabled)
	return panelData
end

function VL_Quest_Button_UI:settingsPanelPos()
	local x = self:getX()
	local y = self:getY()-self.settingsPanel:getHeight()-2
	local width = self:getWidth()

	if y < 1 then
		y = self:getY() + self:getHeight() + 2
	end

	return x,y,width
end

function VL_Quest_Button_UI:prerender()
	local size = setSize()
	self:drawTexture(getTexture("media/ui/questicon_" .. tostring(size) .. ".png"),0,0, 0.85)
end

function VL_Quest_Button_UI:onMouseDown(x,y)
	self.rightMouseDown = true
	ISPanel.onMouseDown(self, x, y)
end

function VL_Quest_Button_UI:onMouseMove(dx, dy)
	if self.rightMouseDown == true then
		self.dragging = true
	end
	ISPanel.onMouseMove(self, dx, dy)
end

function VL_Quest_Button_UI:onMouseUp(x,y)
	if not self.dragging and not self.player_isDead then
		getSoundManager():playUISound("UISelectListItem")
		--self.infopanel:toggleView(getText("IGUI_XP_Health"))
		--Quest_List_UI:new(getPlayer())
		OpenQuestWindow()
	end
	self.dragging = false
	self.rightMouseDown = false

	ISPanel.onMouseUp(self, x, y)
end

local function CreatQuestIcon(idx,player)
	VLF.questPanelData = VL_Quest_Button_UI:new(idx, player, true)
	VLF.questPanelData:addToUIManager()
end

local function RemoveQuestIcon(player)
	VLF.questPanelData:setVisible(false)
end

Events.OnCreatePlayer.Remove(CreatQuestIcon)
Events.OnCreatePlayer.Add(CreatQuestIcon)

Events.OnPlayerDeath.Remove(RemoveQuestIcon)
Events.OnPlayerDeath.Add(RemoveQuestIcon)