HordeCreator = {}

local random_instance = newrandom()

HordeCreator.EveryTenMinutes = function()
	local rollChance = SandboxVars.Hordes.TempHordeRollChance or 4.0 -- percent chance per 10 in-game minutes
	local roll = random_instance:random() * 100 
	-- print("HordeCreator roll:", roll, " vs ", rollChance)
	if roll < rollChance then
		if getPlayer():getVehicle() or GameTime.getInstance():getMultiplier() > 5 then return end
		local minZedCount = SandboxVars.Hordes.TempHordeMinZombies or 25
		if getCell():getZombieList():size() < minZedCount then return end

		local p = getPlayer()
		local znum = getCell():getZombieList():size()
		local i = ZombRand( 0, znum )
		local zomb = getCell():getZombieList():get(i)
		if zomb:getTarget()==nil and zomb:getZ() == 0 and not zomb:getModData().horde then
			local size = SandboxVars.Hordes.TempHordeSize or 25
			if size > znum then
				size = znum
			end
			local data = {
				type = "Civilian",
				size = size,
				posX = zomb:getX(),
				posY = zomb:getY(),
			}
			data = HordeManager.initHordeData(data, "Temp")
			HordeManager.addHorde(data)
			-- print("A temporary horde has formed near the player!")
		end
	end
end
Events.EveryTenMinutes.Add(HordeCreator.EveryTenMinutes)
