EventSystem = {}

EventSystem.events = {"OnTick", "OnPlayerUpdate", "OnZombieUpdate"}
EventSystem.listeners = {}

-- create stuff for each registered event
for _,event in pairs(EventSystem.events) do
    EventSystem[event] = event -- for debugging strings
    EventSystem.listeners[event] = {}
    -- function to redirect an event to all listener's methods
    EventSystem[event] = function(arg1, arg2, arg3, arg4, arg5)
        -- print("Redirecting Event")
        for _,listener in ipairs(EventSystem.listeners[event]) do
            listener.obj[listener.onEventMethod](listener.obj, arg1, arg2, arg3, arg4, arg5)
        end
    end
end


EventSystem.addEventListener = function(obj, event, onEventMethod) 
    -- print("EventSystem.addEventListener")
    -- check for errors
    if Events[event] == nil and CustomEvents[event] == nil then print("ERROR: event "..event.." not found"); return end
    if obj[onEventMethod] == nil then print("ERROR: method "..onEventMethod.." not found"); return end

    -- prevent duplicates
    for _,listener in ipairs(EventSystem.listeners[event]) do
        if listener.obj == obj and listener.onEventMethod == onEventMethod then
            return
        end
    end

    -- add the listener
    local listener = {obj=obj, event=event, onEventMethod=onEventMethod}
    table.insert(EventSystem.listeners[event], listener)

    Events[event].Add(EventSystem[event])
end

EventSystem.removeEventListener = function(obj, event, onEventMethod)
    -- print("EventSystem.removeEventListener")
    -- check for errors
    if EventSystem[event] == nil then print("ERROR: event "..event.." not found"); return end
    if obj[onEventMethod] == nil then print("ERROR: method "..onEventMethod.." not found"); return end

    --remove the listener
    local removed = false
    for i,listener in ipairs(EventSystem.listeners[event]) do
        if listener.obj == obj and listener.onEventMethod == onEventMethod then
            table.remove(EventSystem.listeners[event], i)
            removed = true
            break
        end
    end
    -- if not removed then print("WARNING: listener with method "..onEventMethod.." for event "..event.." wasn't found") end

    -- remove event if we don't need it anymore
    if #EventSystem.listeners[event] == 0 then
        Events[event].Remove(EventSystem[event])
    end
end

EventSystem.removeAllEventListeners = function(obj)
    -- print("EventSystem.removeAllEventListeners")

    for event,listeners in ipairs(EventSystem.listeners) do
        for i,listener in ipairs(listeners) do
            if listener.obj == obj then
                table.remove(EventSystem.listeners[event], i)--TODO: test if i is still correct
            end
            -- remove event if we don't need it anymore
            if #EventSystem.listeners[event] == 0 then
                Events[event].Remove(EventSystem[event])
            end
        end
    end
end


-- EventSystem.seconds = 0
-- EventSystem.EveryMinute = function()
--     EventSystem.seconds = EventSystem.seconds + getGameTime():getGameWorldSecondsSinceLastUpdate()
-- 	if EventSystem.minutes - HM.timestamp >= 200 then
-- 		HM.timestamp = HM.timestamp + 200
-- 		HM.update()
-- 	end
-- end

-- EventSystem.OnTick = function()
--     EventSystem.seconds = EventSystem.seconds + getGameTime():getGameWorldSecondsSinceLastUpdate()
-- 	if EventSystem.seconds >= 60 then
-- 		EventSystem.seconds = EventSystem.seconds - 60
-- 	end
-- end