-- require "HordeData"
-- require "HordeSimulated"
-- require "HordeSandbox"

-- require "eris_minimap/core/em_core"
-- require "eris_minimap/icons/em_mapIconGroupBase"


HordeManager={}
local HM = HordeManager

HM.hordeSizeMultiplier = 2
HM.hordeLengthMultiplier = 1.5
HM.hordeSpawnMultiplier = 1.5
HM.hordeCap = 1000 -- max non-temp hordes

HM.searchRange = 0
HM.searchRangeMAX = 100

HM.hordes = {}

HM.modData = {
	elapsedDays = 0,
	daysSinceVoD = 0,
	homeX = 0,
	homeY = 0,
	playerAtHomeCounter = 0,
	hordes = {},
}

local ingameSec = 160

-- stagger horde updates to avoid one big spike each tick
HM.updateCursor = 1
HM.updateBatchSize = 5
HM.updateCycleActive = false
HM.cycleChangeSandbox = false
HM.cycleVictory = false

HM.createHordesFromData = function(name, data)
	local hData = nil
	local amount = math.ceil(data.amount * HM.hordeSpawnMultiplier)
	local size = math.ceil(SandboxVars.Hordes.StartingSize or data.size)
	local length = math.ceil(data.length * HM.hordeLengthMultiplier)
	for i = 1,amount do 
		for j = 1,length do
			if j == length then
				hData = HM.initHordeData(data, name, name.."-"..i.."-"..j, size)
			else
				hData = HM.initHordeData(data, "", name.."-"..i.."-"..j, size)
			end
			if hData.size > SandboxVars.Hordes.MaxSize then
				hData.size = SandboxVars.Hordes.MaxSize
			end
			HM.addHorde(hData)
		end
	end
end

HM.initHordeData = function(data, name, logName, size)
	local hData = {}
	hData.name = name or data.name --name on debug map
	hData.logName = logName or data.logName or name -- name in log
	hData.size = size or data.size
	hData.posX = data.posX
	hData.posY = data.posY
	hData.type = data.type or data.types[ ZombRand(1, #data.types+1) ]
	return hData
end

HM.getNonTempHordeCount = function()
	local count = 0
	for _,h in ipairs(HM.hordes) do
		if h.name ~= "Temp" then
			count = count + 1
		end
	end
	return count
end

HM.addHorde = function(data)
	if data and data.name ~= "Temp" then
		if HM.getNonTempHordeCount() >= HM.hordeCap then
			return nil
		end
	end
	local horde = Horde:new(data)
	table.insert( HM.hordes, horde )
	table.insert( HM.modData.hordes, horde.modData )
	return horde
end

HM.removeHorde = function(horde, i)
	for _,h2 in ipairs(HM.hordes) do
		if h2.parent == horde then
			h2.parent = nil
		end
	end
	horde:disband()
	table.remove( HM.hordes, i )
	table.remove( HM.modData.hordes, i )
	if horde.mapIcon then
		horde.mapIcon.a = 0
	end
end

HM.connectHordes = function()
	if #HM.hordes >= 2 then
		for i = 1,#HM.hordes-1 do
			local h1 = HM.hordes[i]
			local h2 = HM.hordes[i+1]
			if h1.name == "" and IsoUtils.DistanceManhattenSquare( h1.posX,h1.posY, h2.posX,h2.posY ) <= 11 then
				h1.parent = h2
				h1.type = h2.type
			end
		end
	end
end

HM.update = function()
	if #HM.hordes == 0 then
		HM.updateCycleActive = false
		return
	end

	local start = HM.updateCursor
	if start > #HM.hordes then start = 1 end
	local finish = math.min(start + HM.updateBatchSize - 1, #HM.hordes)

	local pX = getPlayer():getX()
	local pY = getPlayer():getY()

	local i = start
	while i <= finish do
		local horde = HM.hordes[i]
		if horde.disbanded then
			HM.removeHorde(horde, i)
			finish = math.min(finish, #HM.hordes)
		else
			horde:update()
			if SandboxVars.Hordes.VictoryOrDeath then
				if horde.isVirtual == false and VoD.isReady() and HM.modData.daysSinceVoD > SandboxVars.Hordes.VictoryOrDeathCooldown then
					if IsoUtils.DistanceManhattenSquare( horde.posX,horde.posY, HM.modData.homeX,HM.modData.homeY ) < HM.searchRange then
						if SandboxVars.Hordes.VictoryOrDeathRepeatable then
							HM.cycleVictory = true
						end
					end
				end
			end

			if horde.isVirtual == false then HM.cycleChangeSandbox = true end
			if horde.mapIcon then
				horde.mapIcon.x = horde.posX
				horde.mapIcon.y = horde.posY
			end
			-- print("Horde " .. i .. " - pos: (" .. math.floor(horde.posX) .. "," .. math.floor(horde.posY) .. ") size: " .. horde.modData.size .. " type: " .. horde.type .. ")")
			i = i + 1
		end
	end
	-- print("Number of hordes: " .. #HM.hordes)

	if finish >= #HM.hordes then
		-- finished a full cycle
		HM.updateCursor = 1
		HM.updateCycleActive = false
		-- if HM.cycleChangeSandbox == true and HordeSandbox.changedValues == false then HordeSandbox.changeValues()
		-- elseif HM.cycleChangeSandbox == false and HordeSandbox.changedValues == true then HordeSandbox.resetValues()
		-- end
		if HM.cycleVictory then HM.victoryOrDeath() end
		if em_core and em_core.mapIconMetaGroup then
			addMarkers()
			em_core.mapIconMetaGroup.groups.customMarkerGroup:updateGroup()
		end
		HM.cycleVictory = false
		HM.cycleChangeSandbox = false
	else
		HM.updateCursor = finish + 1
	end
end


HM.victoryOrDeath = function()
	local x = HM.modData.homeX + ZombRand(-20, 20)
	local y = HM.modData.homeY + ZombRand(-20, 20)

	--alert all hordes in range
	for _,horde in ipairs(HordeManager.hordes) do
		if IsoUtils.DistanceManhattenSquare(horde.posX,horde.posY, HM.modData.homeX,HM.modData.homeY) < SandboxVars.Hordes.VictoryOrDeathHomingDistance then
			horde:doVictoryOrDeath(x,y)
		end
	end

	VoD.doGunFire(x,y)
	HM.modData.daysSinceVoD = 0
end


HM.OnTick = function()
	if not HM.updateCycleActive then
		ingameSec = ingameSec + GameTime:getInstance():getGameWorldSecondsSinceLastUpdate()
		if ingameSec >= 160 then
			ingameSec = ingameSec - 160
			HM.updateCycleActive = true
			HM.updateCursor = 1
			HM.cycleVictory = false
			HM.cycleChangeSandbox = false
		end
	end

	if HM.updateCycleActive then
		HM.update()
	end
end

HM.OnZombieDead = function(zomb)
	if zomb:getModData().horde then
		local zombHorde = zomb:getModData().horde
		for _,horde in ipairs(HM.hordes) do
			if horde == zombHorde then
				if zomb == horde.leader then horde.leader = nil end
				for i,z in ipairs(horde.zombieList) do
					if z == zomb then
						table.remove( horde.zombieList, i )
						horde.modData.size = horde.modData.size -1
						return
					end
				end
			end
		end
	end
end

HM.EveryDays = function()
	--increase counters
	HM.modData.elapsedDays = HM.modData.elapsedDays +1
	HM.modData.daysSinceVoD = HM.modData.daysSinceVoD +1
	HM.searchRange = HM.modData.elapsedDays/2 + HM.modData.daysSinceVoD*2
	if HM.searchRange > 90 then HM.searchRange = 90 end

	--increase horde size
	for _,horde in ipairs(HM.hordes) do
		if not horde.parent then
			horde.growth_daysCounter = horde.growth_daysCounter +1
			if horde.modData.size < SandboxVars.Hordes.MaxSize and horde.growth_daysCounter >= SandboxVars.Hordes.GrowthTime then
				horde.modData.size = horde.modData.size + SandboxVars.Hordes.GrowthRate
				horde.growth_daysCounter = 0
				-- print("Horde " .. horde.name .. " has grown by " .. SandboxVars.Hordes.GrowthRate .. ", now at ".. horde.modData.size)
			elseif horde.isVirtual and SandboxVars.Hordes.Splitting then
				--split group
				local size = horde.modData.size/2
				if size > SandboxVars.Hordes.MaxSize then
					size = SandboxVars.Hordes.MaxSize
				end
				horde.modData.size = size/2
				data = HM.initHordeData(horde.modData, horde.modData.name, horde.modData.name, size)
				local child = HM.addHorde(data)
				--add new group to tail
				for _,h2 in ipairs(HM.hordes) do
					if h2.parent == horde then
						child.parent = h2
					end
				end
				-- print("Horde " .. horde.name .. " has split, new horde ".. child.name .." at size ".. child.modData.size)
			end
		end
	end
	for key,data in pairs(HordeData.origins) do
		if HM.modData.elapsedDays == data.minDays or (data.chance and ZombRand(101) < data.chance and HM.modData.elapsedDays > data.minDays and HM.modData.elapsedDays <= data.maxDays) then
			HM.createHordesFromData(key, data)
			HM.connectHordes()
		end
	end
end

HM.OnGameStart = function()
	local hData = nil
	local modData = GameTime:getInstance():getModData().hordeModData
	if not modData then
		for key,data in pairs(HordeData.origins) do
			if data.minDays == -1 then
				HM.createHordesFromData(key, data)
			end
		end
	else
		HM.modData.elapsedDays = modData.elapsedDays
		HM.modData.daysSinceVoD = modData.daysSinceVoD
		HM.modData.playerAtHomeCounter = modData.playerAtHomeCounter
		HM.modData.homeX = modData.homeX
		HM.modData.homeY = modData.homeY
		HM.searchRange = HM.modData.elapsedDays/2 + HM.modData.daysSinceVoD*2
		if HM.searchRange > 90 then HM.searchRange = 90 end
			
		-- HordeSandbox.changeValues()--TODO
		-- HordeSandbox.resetValues()

		for _,data in ipairs(modData.hordes) do
			if data.posX and data.posY then
				hData = HM.initHordeData(data)
				if hData.size > SandboxVars.Hordes.MaxSize then
					hData.size = SandboxVars.Hordes.MaxSize
				end
				HM.addHorde(hData)
			end
		end
	end

	HM.connectHordes()

	-- if GameTime:getInstance():getDaysSurvived() > HM.modData.elapsedDays then HM.modData.elapsedDays = GameTime:getInstance():getDaysSurvived()	end
	GameTime:getInstance():getModData().hordeModData = HM.modData

	Events.OnTick.Add( HM.OnTick )
	Events.EveryDays.Add( HM.EveryDays )
	Events.OnZombieDead.Add( HM.OnZombieDead )
end
Events.OnGameStart.Add( HM.OnGameStart )

function addMarkers()
	if em_core and em_core.mapIconMetaGroup then
		local markers = em_core.mapIconMetaGroup.groups.customMarkerGroup
		for _,horde in ipairs(HM.hordes) do
			if horde.mapIcon == nil then
				local mapIcon = markers:createIcon(horde.posX, horde.posY, horde.name..tostring(ZombRand(1000)))
				mapIcon.iconData = horde.name
				horde.mapIcon = mapIcon
			end
		end
	end
end
