




function REX5DRAWARROW(player)
    -- Check if bow is equipped in hands
    local bow = player:getPrimaryHandItem();

    if bow and bow:getType() == "Primitive_Bow" then
        local hasAmmo = bow:getCurrentAmmoCount() > 0;
        local attachedClip = bow:getWeaponPart("RecoilPad");

        -- Find arrow clip in inventory
        local arrowClip = nil;
        local items = player:getInventory():getItems();
        for i=0, items:size()-1 do
            if items:get(i):getType() == "Clip_REX5_BOW" then
                arrowClip = items:get(i);
                break;
            end
        end

        -- Check ammo count and manage attachments
        if hasAmmo then
            -- Has ammo - attach arrow clip if not already attached
            if not attachedClip and arrowClip then
                bow:attachWeaponPart(arrowClip);
            end

            -- Swap sprite when aiming
            if player:isAiming() then
                bow:setWeaponSprite("REX5_MD_BOW");
            else
                bow:setWeaponSprite("Primitive_Bow");
            end

            player:resetEquippedHandsModels();
        else
            -- No ammo - detach arrow if attached
            if attachedClip then
                bow:detachWeaponPart(attachedClip);
            end

            bow:setWeaponSprite("Primitive_Bow");
            player:resetEquippedHandsModels();
        end
    end
end





function REX5DRAWCHARGE(player)
    -- Check if bow is equipped in hands
    local bow = player:getPrimaryHandItem();

    if bow and bow:getType() == "Primitive_Bow" then
        local hasAmmo = bow:getCurrentAmmoCount() > 0;

        --swap models based on aiming and ammo
        if hasAmmo and player:isAiming() then
            bow:setWeaponSprite("REX5_MD_BOW");
            player:resetEquippedHandsModels();
        else
            bow:setWeaponSprite("Primitive_Bow");
            player:resetEquippedHandsModels();
        end
    end
end







function REX5CHECKIDLE(player)
    -- Check if bow is equipped in hands
    local bow = player:getPrimaryHandItem();

    if bow and bow:getType() == "Primitive_Bow" then
        if bow:getCurrentAmmoCount() < 1 then
            if not player:isAiming() then
                bow:setWeaponSprite("Primitive_Bow");
                player:resetEquippedHandsModels();
            end
        end
    end
end

Events.OnPlayerUpdate.Add(REX5CHECKIDLE)













Events.OnPlayerUpdate.Add(REX5DRAWCHARGE)





Events.OnPlayerUpdate.Add(REX5DRAWARROW)
