local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    local b = InspectDescription.newBuilder()
    local matched = false

    local function addStats()
        local function fmt(n, d) return InspectUI_fmtNumber(n, d or 1) end

        local weight = statMap["weight"]
        if weight then
            InspectDescription.addFormatted(
                b,
                "IGUI_Inspect_Moveable_Stat_Weight",
                "Weight: %s units.",
                fmt(weight.value or weight.raw, 2)
            )
        end

        local cond = statMap["condition"]
        if cond then
            InspectDescription.addFormatted(
                b,
                "IGUI_Inspect_Moveable_Stat_Condition",
                "Condition: %s%%.",
                fmt(cond.value or cond.raw, 0)
            )
        end
    end

    --------------------------------------------------------
    -- FURNITURE (only subtype)
    --------------------------------------------------------
    if child == "Furniture" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Moveable_Furniture_Base",
                "Furniture or moveable object used to furnish or decorate environments.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Moveable_Furniture_Usage",
                "Can be repositioned or dismantled depending on its construction.")
        )

        matched = true
    end

    --------------------------------------------------------
    -- FALLBACK
    --------------------------------------------------------
    if not matched then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Moveable_Fallback",
                "Moveable object with basic decorative or functional purpose.")
        )
    end

    --------------------------------------------------------
    -- STATS
    --------------------------------------------------------
    addStats()

    --------------------------------------------------------
    -- PLUGINS
    --------------------------------------------------------
    local extra =
        InspectPlugins.appendMoveableLines and
        InspectPlugins.appendMoveableLines(item, statMap, child, parent)

    if extra then
        if type(extra) == "string" then
            InspectDescription.addLine(b, extra)
        else
            for _, line in ipairs(extra) do
                InspectDescription.addLine(b, line)
            end
        end
    end

    return InspectDescription.finish(b)
end

return M
