local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    local b = InspectDescription.newBuilder()
    local matched = false

    --------------------------------------------------------
    -- CARD
    --------------------------------------------------------
    if child == "Card" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Lit_Card_Base",
                "Printed card used for identification, business information, or collection.")
        )
        matched = true
    elseif child == "Magazine" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Lit_Magazine_Base",
                "Magazine or manual containing focused instructions or practical tips.")
        )

        local skill = statMap["skillBook"]
        if skill then
            InspectDescription.addFormatted(
                b,
                "IGUI_Inspect_Book_Description_Skill",
                "Related to skill: %s.",
                tostring(skill.value)
            )
        end

        local pages = statMap["pagesTotal"]
        if pages then
            InspectDescription.addFormatted(
                b,
                "IGUI_Inspect_Book_Description_Pages",
                "Contains approximately %s pages.",
                tostring(pages.value)
            )
        end
        matched = true
    elseif child == "Map" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Lit_Map_Base",
                "Map sheet used for navigation within specific regions.")
        )
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Lit_Map_Usage",
                "Provides landmarks and routes useful for travel planning.")
        )
        matched = true
    end

    --------------------------------------------------------
    -- BOOK (FALLBACK)
    --------------------------------------------------------
    if not matched then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Book_Description_Base",
                "Book designed for reading, study, or skill progression.")
        )

        local skill = statMap["skillBook"]
        if skill then
            InspectDescription.addFormatted(
                b,
                "IGUI_Inspect_Book_Description_Skill",
                "Related to skill: %s.",
                tostring(skill.value)
            )
        end

        local total = statMap["pagesTotal"]
        local left  = statMap["pagesLeft"]

        if total and left then
            InspectDescription.addFormatted(
                b,
                "IGUI_Inspect_Book_Description_PagesLeft",
                "Contains approximately %s pages; around %s remain unread.",
                tostring(total.value),
                tostring(left.value)
            )
        elseif total then
            InspectDescription.addFormatted(
                b,
                "IGUI_Inspect_Book_Description_Pages",
                "Contains approximately %s pages.",
                tostring(total.value)
            )
        end
    end

    --------------------------------------------------------
    -- PLUGINS
    --------------------------------------------------------
    local extra =
        InspectPlugins.appendLiteratureLines and
        InspectPlugins.appendLiteratureLines(item, statMap, child, parent)

    if extra then
        if type(extra) == "string" then
            InspectDescription.addLine(b, extra)
        else
            for _, line in ipairs(extra) do
                InspectDescription.addLine(b, line)
            end
        end
    end

    return InspectDescription.finish(b)
end

return M
