local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    local b = InspectDescription.newBuilder()
    local matched = false

    --------------------------------------------------------
    -- DUNG
    --------------------------------------------------------
    if child == "Dung" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Junk_Dung_Base",
                "Animal droppings with limited practical use.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Junk_Dung_Usage",
                "Sometimes used as crude fertilizer, bait, or discarded.")
        )

        matched = true
    elseif child == "Broken" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Junk_Broken_Base",
                "Broken or damaged item with minimal usable function.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Junk_Broken_Usage",
                "Can be scrapped for materials or disposed of.")
        )

        matched = true
    elseif child == "Smoking" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Junk_Smoking_Base",
                "Smoking implement such as a pipe, cigar, or cigarette.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Junk_Smoking_Usage",
                "Used for smoking and may influence stress or mood.")
        )

        matched = true
    end


    --------------------------------------------------------
    -- FALLBACK
    --------------------------------------------------------
    if not matched then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Junk_Base",
                "Miscellaneous item with limited utility or collectible value.")
        )
    end


    --------------------------------------------------------
    -- PLUGINS
    --------------------------------------------------------
    local extra =
        InspectPlugins.appendJunkLines and
        InspectPlugins.appendJunkLines(item, statMap, child, parent)

    if extra then
        if type(extra) == "string" then
            InspectDescription.addLine(b, extra)
        elseif type(extra) == "table" then
            for _, line in ipairs(extra) do
                InspectDescription.addLine(b, line)
            end
        end
    end

    return InspectDescription.finish(b)
end

return M
