local DescMelee = require "InspectSystem/Modules/Desc_Melee"
local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    --------------------------------------------------------
    -- Garden weapons use the melee module
    --------------------------------------------------------
    if child == "GardenWeapon" then
        return DescMelee.describe(item, statMap, child, parent)
    end

    local b = InspectDescription.newBuilder()
    local matched = false

    --------------------------------------------------------
    -- SEED PACKET
    --------------------------------------------------------
    if child == "SeedPacket" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Garden_SeedPacket_Base",
                "Packet containing multiple seeds intended for planting.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Garden_SeedPacket_Usage",
                "Can be opened to obtain individual seeds for farming plots.")
        )

        matched = true
    elseif child == "Seed" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Garden_Seed_Base",
                "Single seed used to grow a specific crop or plant.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Garden_Seed_Usage",
                "Plant in prepared soil and water regularly to ensure growth.")
        )

        matched = true
    elseif child == "Plants" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Garden_Plant_Base",
                "Young plant or sapling intended for cultivation.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Garden_Plant_Usage",
                "Place in suitable soil and maintain proper conditions to mature.")
        )

        matched = true
    end

    --------------------------------------------------------
    -- FALLBACK
    --------------------------------------------------------
    if not matched then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Garden_Fallback",
                "Gardening-related object with basic horticultural use.")
        )
    end

    --------------------------------------------------------
    -- PLUGINS
    --------------------------------------------------------
    local extra =
        InspectPlugins.appendGardeningLines and
        InspectPlugins.appendGardeningLines(item, statMap, child, parent)

    if extra then
        if type(extra) == "string" then
            InspectDescription.addLine(b, extra)
        elseif type(extra) == "table" then
            for _, line in ipairs(extra) do
                InspectDescription.addLine(b, line)
            end
        end
    end

    return InspectDescription.finish(b)
end

return M
