local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    local b = InspectDescription.newBuilder()

    --------------------------------------------------------
    -- 1) Base según subcategoría (descripción principal)
    --------------------------------------------------------
    if child == "Drink" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Food_Base_Drink",
                "A drinkable item that helps reduce thirst and may provide calories.")
        )

    elseif child == "Fruit" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Food_Base_Fruit",
                "A fresh fruit rich in vitamins and natural sugars.")
        )

    elseif child == "Vegetable" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Food_Base_Vegetable",
                "A fresh vegetable offering nutrients and low calories.")
        )

    elseif child == "Meat" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Food_Base_Meat",
                "Raw meat that provides strong nutrition but may spoil quickly.")
        )

    elseif child == "Spice" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Food_Base_Spice",
                "A seasoning item used to improve flavor when cooking.")
        )

    elseif child == "Liquor" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Food_Base_Liquor",
                "Alcoholic beverage intended for drinking or mixing.")
        )

    elseif child == "Prepared" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Food_Base_Prepared",
                "A cooked or prepared dish offering improved nutrition.")
        )

    elseif child == "Perishable" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Food_Base_Perishable",
                "A perishable food item that will spoil after some days.")
        )

    elseif child == "NonPerishable" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Food_Base_NonPerishable",
                "A non-perishable food item suitable for long-term storage.")
        )

    else
        -- fallback dentro de Food
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Food_Description_BaseFood",
                "Food item that can be eaten to reduce hunger.")
        )
    end

    --------------------------------------------------------
    -- 2) Stats nutricionales (una linea por stat)
    --------------------------------------------------------
    local hungerStat   = statMap["hunger"]
    local thirstStat   = statMap["thirst"]
    local caloriesStat = statMap["calories"]
    local carbsStat    = statMap["carbs"]
    local proteinsStat = statMap["proteins"]
    local fatStat      = statMap["fat"]
    local freshStat    = statMap["daysFresh"]
    local rottenStat   = statMap["daysRotten"]

    if hungerStat then
        local hVal = math.abs(tonumber(hungerStat.raw) or 0)
        local hTxt = InspectUI_fmtNumber(hVal, 2)
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Food_Description_Hunger",
            "Reduces hunger by around %s.",
            hTxt
        )
    end

    if thirstStat then
        local tVal = math.abs(tonumber(thirstStat.raw) or 0)
        local tTxt = InspectUI_fmtNumber(tVal, 2)
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Food_Description_Thirst",
            "Reduces thirst by around %s.",
            tTxt
        )
    end

    if caloriesStat then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Food_Description_Calories",
            "Provides roughly %s calories.",
            tostring(caloriesStat.value)
        )
    end

    if carbsStat then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Food_Description_Carbs",
            "Contains about %s g of carbohydrates.",
            tostring(carbsStat.value)
        )
    end

    if proteinsStat then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Food_Description_Proteins",
            "Contains about %s g of proteins.",
            tostring(proteinsStat.value)
        )
    end

    if fatStat then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Food_Description_Fat",
            "Contains about %s g of fat.",
            tostring(fatStat.value)
        )
    end

    --------------------------------------------------------
    -- 3) Frescura / descomposicion (según dias)
    --------------------------------------------------------
    if freshStat and rottenStat then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Food_Description_FreshRot",
            "Stays fresh for about %s days and fully spoils after roughly %s days.",
            tostring(freshStat.value),
            tostring(rottenStat.value)
        )
    elseif freshStat then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Food_Description_Fresh",
            "Stays fresh for about %s days.",
            tostring(freshStat.value)
        )
    elseif rottenStat then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Food_Description_Rot",
            "Fully spoils after roughly %s days.",
            tostring(rottenStat.value)
        )
    end

    --------------------------------------------------------
    -- 4) Hook de plugins especificos de Food (si existiera)
    --------------------------------------------------------
    local extra = InspectPlugins and InspectPlugins.appendFoodLines
        and InspectPlugins.appendFoodLines(item, statMap, child, parent) or nil

    if extra and type(extra) == "table" then
        for _, line in ipairs(extra) do
            InspectDescription.addLine(b, line)
        end
    elseif type(extra) == "string" and extra ~= "" then
        InspectDescription.addLine(b, extra)
    end

    --------------------------------------------------------
    -- 5) Finalizar builder
    --------------------------------------------------------
    return InspectDescription.finish(b)
end

return M
