local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    local b = InspectDescription.newBuilder()
    local subtype = child

    -- Compatibilidad con posibles valores previos
    if subtype == "Radio" then
        subtype = "RadioReceiver"
    end

    --------------------------------------------------------
    -- 1) BASE DESCRIPTION POR SUBTIPO
    --------------------------------------------------------
    if subtype == "Battery" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Electronics_Base_Battery",
                "Lithium-based power cell with residual discharge cycles.")
        )

    elseif subtype == "ElectronicPart" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Electronics_Base_ElectronicPart",
                "General-purpose electronic component suitable for repair and assembly.")
        )

    elseif subtype == "ElectronicTool" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Electronics_Base_ElectronicTool",
                "Diagnostic electronic instrument intended for calibration and repair operations.")
        )

    elseif subtype == "RemoteController" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Electronics_Base_RemoteController",
                "Infrared-based remote actuation device for signal triggering.")
        )

    elseif subtype == "EntertainmentDevice" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Electronics_Base_EntertainmentDevice",
                "Compact electronic unit designed for personal entertainment and media playback.")
        )

    elseif subtype == "AudioDevice" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Electronics_Base_AudioDevice",
                "Audio output device engineered for signal amplification and reproduction.")
        )

    elseif subtype == "LightBulb" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Electronics_Base_LightBulb",
                "Electrical light bulb intended for use within compatible fixtures.")
        )

    elseif subtype == "LightSource" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Electronics_Base_LightSource",
                "Portable illumination device delivering a controlled luminous output.")
        )

    elseif subtype == "Generator" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Electronics_Base_Generator",
                "Fuel-powered generator providing continuous electrical output over time.")
        )

    elseif subtype == "RadioReceiver" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Electronics_Base_RadioReceiver",
                "Radio-frequency receiver optimized for narrowband signal acquisition.")
        )

    elseif subtype == "RadioTransceiver" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Electronics_Base_RadioTransceiver",
                "Bidirectional RF communication unit supporting short-to-medium range transmission.")
        )

    else
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Electronics_Base_Fallback",
                "Electronic device with general-purpose operational functionality.")
        )
    end


    --------------------------------------------------------
    -- 2) STATS BASICOS
    --------------------------------------------------------
    local function fmt(n, d)
        return InspectUI_fmtNumber(n, d or 1)
    end

    local cond = statMap["condition"]
    if cond then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_Condition",
            "Operational condition: %s%%.",
            fmt(cond.value or cond.raw, 0)
        )
    end

    local weight = statMap["weight"]
    if weight then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_Weight",
            "Weight: %s units.",
            fmt(weight.value or weight.raw, 2)
        )
    end

    local uses = statMap["usesLeft"]
    if uses then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_UsesLeft",
            "Approximate remaining cycles: %s.",
            fmt(uses.value or uses.raw, 0)
        )
    end


    --------------------------------------------------------
    -- 3) SUBSTATS AVANZADOS (solo si existen)
    --------------------------------------------------------
    -- Energia
    local powerCons = statMap["powerConsumption"]
    if powerCons then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_PowerConsumption",
            "Power consumption: %s W.",
            fmt(powerCons.value or powerCons.raw, 2)
        )
    end

    local powerOut = statMap["powerOutput"]
    if powerOut then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_PowerOutput",
            "Output power: %s W.",
            fmt(powerOut.value or powerOut.raw, 2)
        )
    end

    local drain = statMap["batteryDrainRate"]
    if drain then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_BatteryDrainRate",
            "Battery drain rate: %s units/hour.",
            fmt(drain.value or drain.raw, 2)
        )
    end

    -- Se�al / radiofrecuencia
    local range = statMap["signalRange"]
    if range then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_SignalRange",
            "Signal range: %s meters.",
            fmt(range.value or range.raw, 1)
        )
    end

    local clarity = statMap["signalClarity"]
    if clarity then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_SignalClarity",
            "Signal clarity rating: %s.",
            fmt(clarity.value or clarity.raw, 1)
        )
    end

    local freq = statMap["frequencySupport"]
    if freq then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_FrequencySupport",
            "Supported frequency range: %s.",
            tostring(freq.value or freq.raw)
        )
    end

    -- Iluminacion
    local lumens = statMap["lumensEquivalent"]
    if lumens then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_Lumens",
            "Luminous output equivalent: %s lm.",
            fmt(lumens.value or lumens.raw, 0)
        )
    end

    local beam = statMap["beamDistance"]
    if beam then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_BeamDistance",
            "Effective beam distance: %s meters.",
            fmt(beam.value or beam.raw, 1)
        )
    end

    -- Calor / riesgo
    local heat = statMap["heatOutput"]
    if heat then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_HeatOutput",
            "Thermal output: %s°C.",
            fmt(heat.value or heat.raw, 1)
        )
    end

    local risk = statMap["riskRating"]
    if risk then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_RiskRating",
            "Operational risk rating: %s.",
            tostring(risk.value or risk.raw)
        )
    end

    -- Capacidad / canales
    local mem = statMap["memoryCapacity"]
    if mem then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_MemoryCapacity",
            "Memory capacity: %s.",
            tostring(mem.value or mem.raw)
        )
    end

    local ch = statMap["channelCount"]
    if ch then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_ChannelCount",
            "Supported channels: %s.",
            tostring(ch.value or ch.raw)
        )
    end

    -- Audio
    local gain = statMap["audioGain"]
    if gain then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_AudioGain",
            "Audio gain: %s dB.",
            fmt(gain.value or gain.raw, 1)
        )
    end

    local nf = statMap["noiseFilter"]
    if nf then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Electronics_Stat_NoiseFilter",
            "Noise filtering level: %s.",
            tostring(nf.value or nf.raw)
        )
    end


    --------------------------------------------------------
    -- 4) PLUGINS
    --------------------------------------------------------
    local extra = InspectPlugins.appendElectronicsLines
        and InspectPlugins.appendElectronicsLines(item, statMap, subtype, parent)

    if extra then
        if type(extra) == "string" then
            InspectDescription.addLine(b, extra)
        elseif type(extra) == "table" then
            for _, line in ipairs(extra) do
                InspectDescription.addLine(b, line)
            end
        end
    end

    --------------------------------------------------------
    -- 5) FINALIZAR
    --------------------------------------------------------
    return InspectDescription.finish(b)
end

return M
