local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

local SPECIES = {
    { key = "boar",     tokens = { "boar" } },
    { key = "piglet",   tokens = { "piglet" } },
    { key = "bull",     tokens = { "bull" } },
    { key = "cow",      tokens = { "cow" } },
    { key = "calf",     tokens = { "calf" } },
    { key = "rabbit",   tokens = { "rabbit", "bunny" } },
    { key = "mouse",    tokens = { "mouse" } },
    { key = "rat",      tokens = { "rat" } },
    { key = "chick",    tokens = { "chick" } },
    { key = "cockerel", tokens = { "cockerel" } },
    { key = "hen",      tokens = { "hen" } },
    { key = "ewe",      tokens = { "ewe" } },
    { key = "lamb",     tokens = { "lamb" } },
    { key = "ram",      tokens = { "ram" } },
    { key = "raccoon",  tokens = { "raccoon" } },
    { key = "buck",     tokens = { "buck" } },
    { key = "doe",      tokens = { "doe" } },
    { key = "fawn",     tokens = { "fawn" } },
}

local function matchTokens(text, tokens)
    for _, token in ipairs(tokens) do
        if text:find(token, 1, true) then
            return true
        end
    end
    return false
end

local function lower(val)
    if not val then return "" end
    return string.lower(tostring(val))
end

local function getText(item)
    local name = lower(item.getDisplayName and item:getDisplayName())
    local dc   = lower(item.getDisplayCategory and item:getDisplayCategory())
    local cat  = lower(item.getCategory and item:getCategory())
    return (name or "") .. " " .. (dc or "") .. " " .. (cat or "")
end

local function detectSpecies(item)
    local text = getText(item)
    for _, entry in ipairs(SPECIES) do
        if matchTokens(text, entry.tokens) then
            return entry.key
        end
    end
    return nil
end

function M.describe(item, statMap, child, parent)
    if parent == "Corpse" and child == "DeadAnimal" then
        local b = InspectDescription.newBuilder()
        local speciesKey = detectSpecies(item)
        local speciesFallback = InspectUI_tr("IGUI_Inspect_Corpse_SpeciesFallback", "animal")
        local speciesLabel = speciesKey and InspectUI_tr("IGUI_Inspect_Corpse_Species_" .. speciesKey, speciesKey) or speciesFallback

        --------------------------------------------------------
        -- 1) SPECIES DETECTION
        --------------------------------------------------------
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Corpse_Base_Line1",
            "Carcass of a %s, recently deceased.",
            speciesLabel
        )

        --------------------------------------------------------
        -- 2) BASE LINES
        --------------------------------------------------------
        InspectDescription.addLine(
            b,
            InspectUI_tr("IGUI_Inspect_Corpse_Base_Line2",
                "Can be butchered or processed for usable materials.")
        )

        InspectDescription.addLine(
            b,
            InspectUI_tr("IGUI_Inspect_Corpse_Base_Line3",
                "Spoils over time; handle with care.")
        )

        --------------------------------------------------------
        -- 3) PLUGINS
        --------------------------------------------------------
        local extra = InspectPlugins.appendCorpseLines
            and InspectPlugins.appendCorpseLines(item, statMap, speciesKey, parent)

        if extra then
            if type(extra) == "string" then
                InspectDescription.addLine(b, extra)
            elseif type(extra) == "table" then
                for _, line in ipairs(extra) do
                    InspectDescription.addLine(b, line)
                end
            end
        end

        return InspectDescription.finish(b)
    end
end

return M
