local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    local b = InspectDescription.newBuilder()
    local subtype = child

    --------------------------------------------------------
    -- 1) BASE DESCRIPTION
    --------------------------------------------------------
    if subtype == "Headwear" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Clothing_Base_Headwear",
                "Protective headwear offering basic environmental resistance.")
        )

    elseif subtype == "Facewear" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Clothing_Base_Facewear",
                "Face protection designed to reduce exposure and improve safety.")
        )

    elseif subtype == "Gloves" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Clothing_Base_Gloves",
                "Handwear providing grip, insulation, and minor protection.")
        )

    elseif subtype == "Footwear" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Clothing_Base_Footwear",
                "Footwear improving movement stability and offering basic protection.")
        )

    elseif subtype == "Bottoms" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Clothing_Base_Bottoms",
                "Lower-body clothing providing warmth and limited physical protection.")
        )

    elseif subtype == "Tops" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Clothing_Base_Tops",
                "Upper-body clothing offering warmth and minor protection.")
        )

    elseif subtype == "FullBody" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Clothing_Base_FullBody",
                "Full-body outfit providing broad coverage and protection.")
        )

    elseif subtype == "Armor" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Clothing_Base_Armor",
                "Armor-grade clothing designed to resist physical damage.")
        )

    elseif subtype == "Special" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Clothing_Base_Special",
                "Specialized clothing piece with functional utility.")
        )

    else
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Clothing_Base_Fallback",
                "A clothing item offering basic protection and insulation.")
        )
    end


    --------------------------------------------------------
    -- 2) STATS
    --------------------------------------------------------
    local function fmt(n, d)
        return InspectUI_fmtNumber(n, d or 1)
    end

    local ins = statMap["insulation"]
    if ins then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Clothing_Stat_Insulation",
            "Provides approximately %s thermal insulation.",
            fmt(ins.value or ins.raw, 2)
        )
    end

    local wind = statMap["windRes"]
    if wind then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Clothing_Stat_WindRes",
            "Blocks around %s%% of wind.",
            fmt(wind.value or wind.raw, 1)
        )
    end

    local water = statMap["waterRes"]
    if water then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Clothing_Stat_WaterRes",
            "Provides approximately %s%% water resistance.",
            fmt(water.value or water.raw, 1)
        )
    end

    local bite = statMap["bite"] or statMap["biteDefense"]
    if bite then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Clothing_Stat_Bite",
            "Bite protection: %s%%.",
            fmt(bite.value or bite.raw, 1)
        )
    end

    local scratch = statMap["scratch"] or statMap["scratchDefense"]
    if scratch then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Clothing_Stat_Scratch",
            "Scratch protection: %s%%.",
            fmt(scratch.value or scratch.raw, 1)
        )
    end

    local run = statMap["runSpeedModifier"] or statMap["runSpeed"]
    if run then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Clothing_Stat_RunSpeed",
            "Run speed modifier: %s.",
            fmt(run.value or run.raw, 2)
        )
    end

    local weight = statMap["weight"]
    if weight then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Clothing_Stat_Weight",
            "Weight: %s units.",
            fmt(weight.value or weight.raw, 2)
        )
    end

    local condition = statMap["condition"]
    if condition then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Clothing_Stat_Condition",
            "Condition: %s.",
            fmt(condition.value or condition.raw, 0)
        )
    end


    --------------------------------------------------------
    -- 3) PLUGINS
    --------------------------------------------------------
    local extra = InspectPlugins.appendClothingLines
        and InspectPlugins.appendClothingLines(item, statMap, subtype, parent)

    if extra then
        if type(extra) == "string" then
            InspectDescription.addLine(b, extra)
        elseif type(extra) == "table" then
            for _, line in ipairs(extra) do
                InspectDescription.addLine(b, line)
            end
        end
    end

    --------------------------------------------------------
    -- 4) FINALIZAR
    --------------------------------------------------------
    return InspectDescription.finish(b)
end

return M
