local M = {}

M.defs = {

    --------------------------------------------------------
    -- DAMAGE
    --------------------------------------------------------
    {
        id = "minDamage",
        labelKey = "IGUI_Inspect_Melee_MinDamage",
        fallback = "Min damage",
        getter = function(item)
            return item.getMinDamage and item:getMinDamage()
        end,
    },
    {
        id = "maxDamage",
        labelKey = "IGUI_Inspect_Melee_MaxDamage",
        fallback = "Max damage",
        getter = function(item)
            return item.getMaxDamage and item:getMaxDamage()
        end,
    },
    {
        id = "treeDamage",
        labelKey = "IGUI_Inspect_Melee_TreeDamage",
        fallback = "Tree damage",
        getter = function(item)
            return item.getTreeDamage and item:getTreeDamage()
        end,
    },
    {
        id = "doorDamage",
        labelKey = "IGUI_Inspect_Melee_DoorDamage",
        fallback = "Door damage",
        getter = function(item)
            return item.getDoorDamage and item:getDoorDamage()
        end,
    },

    --------------------------------------------------------
    -- RANGE / SPEED / CONTROL
    --------------------------------------------------------
    {
        id = "range",
        labelKey = "IGUI_Inspect_Melee_Range",
        fallback = "Range",
        getter = function(item)
            return item.getMaxRange and item:getMaxRange()
        end,
    },
    {
        id = "baseSpeed",
        labelKey = "IGUI_Inspect_Melee_BaseSpeed",
        fallback = "Base speed",
        getter = function(item)
            return item.getBaseSpeed and item:getBaseSpeed()
        end,
    },
    {
        id = "maxHitCount",
        labelKey = "IGUI_Inspect_Melee_MaxHitCount",
        fallback = "Max hit count",
        getter = function(item)
            return item.getMaxHitCount and item:getMaxHitCount()
        end,
    },

    --------------------------------------------------------
    -- CRITICALS / CONDITION
    --------------------------------------------------------
    {
        id = "criticalChance",
        labelKey = "IGUI_Inspect_Melee_CriticalChance",
        fallback = "Critical chance",
        getter = function(item)
            return item.getCriticalChance and item:getCriticalChance()
        end,
    },
    {
        id = "conditionLowerChance",
        labelKey = "IGUI_Inspect_Melee_ConditionLower",
        fallback = "Condition loss chance",
        getter = function(item)
            return item.getConditionLowerChance and item:getConditionLowerChance()
        end,
    },
    {
        id = "doorConditionLowerChance",
        labelKey = "IGUI_Inspect_Melee_DoorConditionLower",
        fallback = "Door-use condition loss",
        getter = function(item)
            return item.getDoorConditionLowerChance and item:getDoorConditionLowerChance()
        end,
    },
    {
        id = "treeConditionLowerChance",
        labelKey = "IGUI_Inspect_Melee_TreeConditionLower",
        fallback = "Tree-use condition loss",
        getter = function(item)
            return item.getTreeConditionLowerChance and item:getTreeConditionLowerChance()
        end,
    },
}

M.order = {
    "minDamage",
    "maxDamage",
    "range",
    "baseSpeed",
    "criticalChance",
    "maxHitCount",
    "treeDamage",
    "doorDamage",
    "conditionLowerChance",
    "doorConditionLowerChance",
    "treeConditionLowerChance",
}

return M
