local M = {}

M.defs = {
    --------------------------------------------------
    -- AMMUNITION
    --------------------------------------------------
    {
        id       = "caliber",
        labelKey = "IGUI_Inspect_Stat_Caliber",
        fallback = "Caliber",
        getter   = function(item)
            if not item then return end

            -- Solo nos interesa si es algun tipo de municion
            local displayCategory = item.getDisplayCategory and item:getDisplayCategory() or ""
            local category        = item.getCategory and item:getCategory() or ""
            local function stripClipSuffix(s)
                if not s then return s end
                s = tostring(s)
                local lower = string.lower(s)
                if #lower >= 4 and lower:sub(-4) == "clip" then
                    s = s:sub(1, #s - 4)
                end
                s = s:gsub("%s+$", "")
                if s == "" then return nil end
                return s
            end

            local function containsIgnoreCase(s, sub)
                if not s or not sub then return false end
                s   = tostring(s)
                sub = tostring(sub)
                s   = string.lower(s)
                sub = string.lower(sub)
                return string.find(s, sub, 1, true) ~= nil
            end

            if not (containsIgnoreCase(displayCategory, "ammo")
                 or containsIgnoreCase(category, "ammo")) then
                return
            end

            local name = item.getDisplayName and item:getDisplayName() or nil
            if not name or name == "" then return end

            local lname  = string.lower(name)
            local tokens = { "9mm", ".45", ".44", ".38", ".308", ".223", "5.56" }

            for _, tok in ipairs(tokens) do
                if string.find(lname, tok, 1, true) then
                    return stripClipSuffix(tok)
                end
            end

            -- Fallback: usa el Script name si existe (Base.9mmRound -> 9mmRound)
            if item.getFullType then
                local full = item:getFullType()
                if full and full ~= "" then
                    local dot = string.find(full, ".", 1, true)
                    if dot then
                        local cleaned = stripClipSuffix(string.sub(full, dot + 1))
                        if cleaned and cleaned ~= "" then
                            return cleaned
                        end
                    else
                        local cleaned = stripClipSuffix(full)
                        if cleaned and cleaned ~= "" then
                            return cleaned
                        end
                    end
                end
            end

            -- Fallback final: el nombre tal cual
            return stripClipSuffix(name)
        end,
    },
}

M.order = {
    "caliber",
}

return M
