------------------------------------------------------------
-- Inspect Icon Resolver v3.1
-- Auto-detection, fallback & debug logging
------------------------------------------------------------

InspectUI_MissingIcons = InspectUI_MissingIcons or {}
InspectUI_IconCache    = InspectUI_IconCache or {}

local ICON_BASE     = "media/textures/ui/InspectStats/"
local ICON_PREFIX   = "Inspect_stat_"
local ICON_SUFFIX   = ".png"
local ICON_FALLBACK = ICON_BASE .. ICON_PREFIX .. "fallback" .. ICON_SUFFIX

-- Ruta de compatibilidad con los iconos antiguos (media/ui/Inspect_stat_*.png)
local LEGACY_BASE   = "media/ui/"

------------------------------------------------------------
-- InspectUI_getStatIcon(statId, size)
-- size opcional: 32 (default) o 64. Proba rutas con carpeta o sufijo.
------------------------------------------------------------
function InspectUI_getStatIcon(statId, size)
    if not statId then
        return getTexture(ICON_FALLBACK)
    end

    size = tonumber(size) or 32

    -- cache key incluye el tamaño solicitado
    local cacheKey = tostring(statId) .. ":" .. tostring(size)
    if InspectUI_IconCache[cacheKey] ~= nil then
        return InspectUI_IconCache[cacheKey]
    end

    local candidates = {
        ICON_BASE .. tostring(size) .. "/" .. ICON_PREFIX .. statId .. ICON_SUFFIX,           -- media/textures/.../32/Inspect_stat_id.png
        ICON_BASE .. ICON_PREFIX .. statId .. "_" .. tostring(size) .. ICON_SUFFIX,          -- media/textures/.../Inspect_stat_id_32.png
        ICON_BASE .. ICON_PREFIX .. statId .. ICON_SUFFIX,                                   -- media/textures/.../Inspect_stat_id.png
        LEGACY_BASE .. ICON_PREFIX .. statId .. ICON_SUFFIX,                                 -- media/ui/Inspect_stat_id.png
    }

    local tex = nil
    for _, path in ipairs(candidates) do
        tex = getTexture(path)
        if tex then
            InspectUI_IconCache[cacheKey] = tex
            return tex
        end
    end

    -- Log solo 1 vez por statId+size
    if not InspectUI_MissingIcons[cacheKey] then
        print("[ItemInspection] Missing icon for stat: "
            .. tostring(statId) .. " size=" .. tostring(size)
            .. " (tried: " .. table.concat(candidates, "; ") .. ")")
        InspectUI_MissingIcons[cacheKey] = true
    end

    local fb = getTexture(ICON_FALLBACK)
    InspectUI_IconCache[cacheKey] = fb
    return fb
end
