----------------------------------------------------------
-- Category_Weapons_Firearm.lua
-- Firearm subcategories (v3.9 modular)
----------------------------------------------------------

local C = {}
C.parent = "Weapons"

local TOKENS = {
    Pistol   = { "pistol", "handgun" },
    Revolver = { "revolver" },
    Rifle    = { "rifle", "carbine", "bolt", "lever" },
    Shotgun  = { "shotgun" },
    SMG      = { "smg", "submachine", "uzi", "mp5" },
}

local function lower(val)
    if not val then return "" end
    return string.lower(tostring(val))
end

local function matchTokens(text, tokens)
    for _, token in ipairs(tokens) do
        if text:find(token, 1, true) then
            return true
        end
    end
    return false
end

local function getDisplayCategory(item)
    return lower(item.getDisplayCategory and item:getDisplayCategory())
end

local function getCategory(item)
    return lower(item.getCategory and item:getCategory())
end

local function getText(item)
    local name = lower(item.getDisplayName and item:getDisplayName())
    local dc   = getDisplayCategory(item)
    local cat  = getCategory(item)
    return (name or "") .. " " .. (dc or "") .. " " .. (cat or "")
end

local function isFirearm(item)
    if not (instanceof and instanceof(item, "HandWeapon")) then
        return false
    end
    if not item.getAmmoType then
        return false
    end
    local ammo = item:getAmmoType()
    return ammo ~= nil and ammo ~= ""
end

local function firearmMatch(item, tokens)
    if not isFirearm(item) then return false end
    return matchTokens(getText(item), tokens)
end

C.rules = {
    {
        id = "Weapons.Firearm.Pistol",
        priority = 92,
        match = function(item, statMap)
            return firearmMatch(item, TOKENS.Pistol)
        end,
        category = "Weapons/Firearm/Pistol",
    },

    {
        id = "Weapons.Firearm.Revolver",
        priority = 92,
        match = function(item, statMap)
            return firearmMatch(item, TOKENS.Revolver)
        end,
        category = "Weapons/Firearm/Revolver",
    },

    {
        id = "Weapons.Firearm.Rifle",
        priority = 92,
        match = function(item, statMap)
            return firearmMatch(item, TOKENS.Rifle)
        end,
        category = "Weapons/Firearm/Rifle",
    },

    {
        id = "Weapons.Firearm.Shotgun",
        priority = 92,
        match = function(item, statMap)
            return firearmMatch(item, TOKENS.Shotgun)
        end,
        category = "Weapons/Firearm/Shotgun",
    },

    {
        id = "Weapons.Firearm.SMG",
        priority = 92,
        match = function(item, statMap)
            return firearmMatch(item, TOKENS.SMG)
        end,
        category = "Weapons/Firearm/SMG",
    },

    -- Fallback firearm bucket
    {
        id = "Weapons.Firearm.zzOther",
        priority = 92,
        match = function(item, statMap)
            return isFirearm(item)
        end,
        category = "Weapons/Firearm/Other",
    },
}

return C
