----------------------------------------------------------
-- Category_Moveable.lua
-- Token-based rules (v3.8)
----------------------------------------------------------

local C = {}
C.parent = "Moveable"

-- token tables
local TOKENS = {
    Furniture = {
        "furniture", "chair", "table", "sofa", "couch", "bench", "desk", "bed",
        "cabinet", "drawer", "shelf", "stool", "wardrobe", "dresser"
    },
}

-- Universal token matcher for all categories
local function matchTokens(text, tokens)
    for _, token in ipairs(tokens) do
        if text:find(token, 1, true) then
            return true
        end
    end
    return false
end

local function lower(val)
    if not val then return "" end
    return string.lower(tostring(val))
end

local function getText(item)
    local name = lower(item.getDisplayName and item:getDisplayName())
    local dc   = lower(item.getDisplayCategory and item:getDisplayCategory())
    return (name or "") .. " " .. (dc or "")
end

local function isMoveable(item)
    local dc = lower(item.getDisplayCategory and item:getDisplayCategory())
    return dc:find("furniture") ~= nil or dc:find("moveable") ~= nil
end

C.rules = {
    {
        id = "Moveable.BaseCheck",
        priority = 50,
        match = function(item, statMap)
            return isMoveable(item)
        end,
        category = "Moveable",
    },

    {
        id = "Moveable.Furniture",
        priority = 100,
        match = function(item, statMap)
            if not isMoveable(item) then return false end
            return matchTokens(getText(item), TOKENS.Furniture)
        end,
        category = "Moveable/Furniture",
    },
}

return C
