----------------------------------------------------------
-- Category_Fluid.lua
-- Token-based rules (v3.8)
----------------------------------------------------------

local C = {}
C.parent = "FluidContainer"

-- token tables
local TOKENS = {
    Water = { "water" },
    Fuel  = { "gas", "petrol", "propane", "fuel" },
}

-- Universal token matcher for all categories
local function matchTokens(text, tokens)
    for _, token in ipairs(tokens) do
        if text:find(token, 1, true) then
            return true
        end
    end
    return false
end

local function lower(val)
    if not val then return "" end
    return string.lower(tostring(val))
end

local function isFluidContainer(item, statMap)
    local hasStat = statMap and statMap["fluidCapacity"] ~= nil
    local dc = lower(item.getDisplayCategory and item:getDisplayCategory())
    local looksLikeWaterContainer = dc:find("watercontainer") ~= nil or dc:find("water") ~= nil
    local isFluid = InspectUI_isFluidContainer and InspectUI_isFluidContainer(item)
    return not (instanceof and instanceof(item, "Food")) and (isFluid or hasStat or looksLikeWaterContainer)
end

local function getText(item)
    local name = lower(item.getDisplayName and item:getDisplayName())
    local dc   = lower(item.getDisplayCategory and item:getDisplayCategory())
    return (name or "") .. " " .. (dc or "")
end

C.rules = {
    {
        id = "FluidContainer.BaseCheck",
        priority = 50,
        match = function(item, statMap)
            return isFluidContainer(item, statMap)
        end,
        category = "FluidContainer",
    },

    {
        id = "FluidContainer.Water",
        priority = 100,
        match = function(item, statMap)
            if not isFluidContainer(item, statMap) then return false end
            return matchTokens(getText(item), TOKENS.Water)
        end,
        category = "FluidContainer/Water",
    },

    {
        id = "FluidContainer.Fuel",
        priority = 100,
        match = function(item, statMap)
            if not isFluidContainer(item, statMap) then return false end
            return matchTokens(getText(item), TOKENS.Fuel)
        end,
        category = "FluidContainer/Fuel",
    },
}

return C
