----------------------------------------------------------
-- Category_Corpse.lua
-- Dead animal carcasses
----------------------------------------------------------

local C = {}
	C.parent = "Corpse"

local TOKENS = {
    DeadAnimal = {
        "corpse", "carcass",
        "boar", "piglet",
        "bull", "cow", "calf",
        "rabbit", "bunny",
        "mouse", "rat",
        "chick", "cockerel", "hen",
        "ewe", "lamb", "ram",
        "raccoon",
        "buck", "doe", "fawn",
    },
}

local function matchTokens(text, tokens)
    for _, token in ipairs(tokens) do
        if text:find(token, 1, true) then
            return true
        end
    end
    return false
end

local function lower(val)
    if not val then return "" end
    return string.lower(tostring(val))
end

local function getText(item)
    local name = lower(item.getDisplayName and item:getDisplayName())
    local dc   = lower(item.getDisplayCategory and item:getDisplayCategory())
    local cat  = lower(item.getCategory and item:getCategory())
    return (name or "") .. " " .. (dc or "") .. " " .. (cat or "")
end

local function isCorpse(item)
    -- Solo tratar como cadáver si es perecedero (food/carcass), evitando peluches tipo Spiffo
    local isPerishable = false
    if item then
        if instanceof and instanceof(item, "Food") then
            isPerishable = true
        elseif item.getOffAge and (item:getOffAge() or 0) > 0 then
            isPerishable = true
        elseif item.getAge and (item:getAge() or 0) > 0 then
            isPerishable = true
        end
    end
    if not isPerishable then return false end

    local text = getText(item)
    return matchTokens(text, TOKENS.DeadAnimal)
end

C.rules = {
    {
        id = "Corpse.BaseCheck",
        priority = 50,
        match = function(item, statMap)
            return isCorpse(item)
        end,
        category = "Corpse",
    },

    {
        id = "Corpse.DeadAnimal",
        priority = 90,
        match = function(item, statMap)
            if not isCorpse(item) then return false end
            return matchTokens(getText(item), TOKENS.DeadAnimal)
        end,
        category = "Corpse/DeadAnimal",
    },
}

return C
