--========================================================
-- ItemInspectionUI - UI entry point (VanillaPlus only)
--========================================================

require "InspectUI/UI/Inspect_UI_VanillaPlus"

InspectUI = InspectUI or {}

local function newCenteredInternal(item, player)
    if not item then return nil end

    local w = 700
    local h = 650

    local core = getCore()
    local sw = core:getScreenWidth()
    local sh = core:getScreenHeight()

    local x = (sw - w) / 2
    local y = (sh - h) / 2

    local ui = InspectUI_VanillaPlus:new(x, y, w, h, item, player)
    ui:initialise()
    ui:addToUIManager()
    ui:setVisible(true)

    return ui
end

-- API pública que usará el contexto
function InspectUI.open(item, player)
    return newCenteredInternal(item, player)
end

return InspectUI
