-- TooltipOverlay.lua
-- Global tooltip renderer – Build 42 safe

TooltipOverlay = TooltipOverlay or {
    text = nil
}

function TooltipOverlay.render()
    if not TooltipOverlay.text or TooltipOverlay.text == "" then return end

    local text = TooltipOverlay.text

    -- Global mouse position
    local mx = getMouseX()
    local my = getMouseY()

    local padding = 6
    local font = UIFont.Small

    local tw = getTextManager():MeasureStringX(font, text)
    local th = getTextManager():getFontHeight(font)

    local x = mx + 12
    local y = my + 12
    local w = tw + padding * 2
    local h = th + padding * 2

    -- Background
    ISUIElement.drawRectStatic(x, y, w, h, 0.92, 0, 0, 0)
    -- Border
    ISUIElement.drawRectBorderStatic(x, y, w, h, 0.9, 0.75, 0.75, 0.75)
    -- Text
    ISUIElement.drawTextStatic(text, x + padding, y + padding, 1,1,1,1, font)
end

Events.OnPostUIDraw.Add(TooltipOverlay.render)
