local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    local b = InspectDescription.newBuilder()
    local subtype = child

    --------------------------------------------------------
    -- 1) BASE DESCRIPTION
    --------------------------------------------------------
    if subtype == "Grenade" or subtype == "PipeBomb" or subtype == "CraftedExplosive" or subtype == "Explosive" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_WeaponUtil_Base_Explosive",
                "Explosive device designed to deliver area damage upon detonation.")
        )

    elseif subtype == "WeaponPart" or subtype == "GunAttachment" or subtype == "GunMod" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_WeaponUtil_Base_WeaponPart",
                "Weapon component intended for modification or repair.")
        )

    elseif subtype == "CookingWeapon" or subtype == "Cooking" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_WeaponUtil_Base_CookingWeapon",
                "Cooking tool adapted for close-quarters impact use.")
        )

    elseif subtype == "GardeningWeapon" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_WeaponUtil_Base_GardeningWeapon",
                "Gardening tool capable of delivering blunt or piercing strikes.")
        )

    elseif subtype == "InstrumentWeapon" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_WeaponUtil_Base_InstrumentWeapon",
                "Instrument repurposed as a blunt-impact weapon.")
        )

    elseif subtype == "WritingWeapon" or subtype == "Household/Writing" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_WeaponUtil_Base_WritingWeapon",
                "Writing tool capable of limited puncture damage.")
        )

    elseif subtype == "HouseholdWeapon" or subtype == "Household" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_WeaponUtil_Base_HouseholdWeapon",
                "Household item adapted for improvised defensive use.")
        )

    else
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_WeaponUtil_Base_Fallback",
                "Improvised weapon suitable for emergency defense.")
        )
    end

    --------------------------------------------------------
    -- 2) STATS (common weapon utility)
    --------------------------------------------------------
    local function fmt(n, d)
        return InspectUI_fmtNumber(n, d or 1)
    end

    local dmg = statMap["damage"]
    if dmg then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_WeaponUtil_Stat_Damage",
            "Base damage: %s.",
            fmt(dmg.value or dmg.raw, 1)
        )
    end

    local rng = statMap["range"]
    if rng then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_WeaponUtil_Stat_Range",
            "Effective range: %s meters.",
            fmt(rng.value or rng.raw, 2)
        )
    end

    local crit = statMap["crit"] or statMap["critChance"]
    if crit then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_WeaponUtil_Stat_Crit",
            "Critical chance: %s%%.",
            fmt(crit.value or crit.raw, 1)
        )
    end

    local swing = statMap["swingTime"]
    if swing then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_WeaponUtil_Stat_SwingTime",
            "Swing time: %s sec.",
            fmt(swing.value or swing.raw, 2)
        )
    end

    local cond = statMap["condition"]
    if cond then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_WeaponUtil_Stat_Condition",
            "Condition: %s%%.",
            fmt(cond.value or cond.raw, 0)
        )
    end

    local wt = statMap["weight"]
    if wt then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_WeaponUtil_Stat_Weight",
            "Weight: %s units.",
            fmt(wt.value or wt.raw, 2)
        )
    end

    --------------------------------------------------------
    -- 3) PLUGINS
    --------------------------------------------------------
    local extra = InspectPlugins.appendWeaponUtilityLines
        and InspectPlugins.appendWeaponUtilityLines(item, statMap, subtype, parent)

    if extra then
        if type(extra) == "string" then
            InspectDescription.addLine(b, extra)
        elseif type(extra) == "table" then
            for _, line in ipairs(extra) do
                InspectDescription.addLine(b, line)
            end
        end
    end

    return InspectDescription.finish(b)
end

return M
