local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    local b = InspectDescription.newBuilder()
    local subtype = child

    --------------------------------------------------------
    -- 1) BASE DESCRIPTION
    --------------------------------------------------------
    if subtype == "Axe" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Melee_Base_Axe",
                "A sturdy axe designed for close combat and chopping force.")
        )

    elseif subtype == "LongBlunt" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Melee_Base_LongBlunt",
                "A long blunt weapon built for heavy impact strikes.")
        )

    elseif subtype == "ShortBlunt" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Melee_Base_ShortBlunt",
                "A compact blunt weapon suitable for quick close-range hits.")
        )

    elseif subtype == "LongBlade" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Melee_Base_LongBlade",
                "A long bladed weapon offering extended reach and cutting power.")
        )

    elseif subtype == "ShortBlade" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Melee_Base_ShortBlade",
                "A short bladed weapon optimized for fast and precise attacks.")
        )

    elseif subtype == "Spear" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Melee_Base_Spear",
                "A spear focused on reach and piercing capabilities.")
        )

    elseif subtype == "Improvised" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Melee_Base_Improvised",
                "An improvised melee weapon with basic effectiveness.")
        )

    else
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Melee_Base_Fallback",
                "A melee weapon designed for close combat.")
        )
    end


    --------------------------------------------------------
    -- 2) STATS (one line per stat)
    --------------------------------------------------------
    local function fmt(n, d)
        return InspectUI_fmtNumber(n, d or 1)
    end

    -- DAMAGE
    local damage = statMap["damage"]
    if damage then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Melee_Stat_Damage",
            "Deals around %s damage.",
            fmt(damage.value or damage.raw, 1)
        )
    end

    -- CRITICAL CHANCE
    local crit = statMap["critChance"] or statMap["crit"]
    if crit then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Melee_Stat_Crit",
            "Has a critical hit chance of around %s%%.",
            fmt(crit.value or crit.raw, 1)
        )
    end

    -- CRITICAL MULTIPLIER
    local mult = statMap["critMultiplier"]
    if mult then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Melee_Stat_CritMult",
            "Critical hits deal %s× damage.",
            fmt(mult.value or mult.raw, 1)
        )
    end

    -- RANGE
    local range = statMap["range"]
    if range then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Melee_Stat_Range",
            "Provides an effective reach of about %s meters.",
            fmt(range.value or range.raw, 2)
        )
    end

    -- MULTI HIT
    local multiHit = statMap["multiHit"]
    if (multiHit and (multiHit.value == true or multiHit.raw == true)) then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Melee_Stat_MultiHit",
                "Can strike multiple targets.")
        )
    elseif item and item.getMaxHitCount then
        local maxHit = item:getMaxHitCount()
        if maxHit and maxHit > 1 then
            InspectDescription.addLine(b,
                InspectUI_tr("IGUI_Inspect_Melee_Stat_MultiHit",
                    "Can strike multiple targets.")
            )
        end
    end

    -- KNOCKBACK
    local knockback = statMap["knockback"]
    if knockback then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Melee_Stat_Knockback",
                "Provides increased knockback force.")
        )
    end

    -- KNOCKDOWN CHANCE
    local knockdown = statMap["knockdown"]
    if knockdown then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Melee_Stat_Knockdown",
            "Has a knockdown chance of around %s%%.",
            fmt(knockdown.value or knockdown.raw, 1)
        )
    end

    -- SWING TIME
    local swing = statMap["swingTime"]
    if swing then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Melee_Stat_Swing",
            "Has a swing time of approximately %s seconds.",
            fmt(swing.value or swing.raw, 2)
        )
    end

    -- RECOVERY
    local recovery = statMap["recovery"]
    if recovery then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Melee_Stat_Recovery",
            "Requires about %s seconds to recover between swings.",
            fmt(recovery.value or recovery.raw, 2)
        )
    end

    -- CONDITION
    local condition = statMap["condition"]
    if condition then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Melee_Stat_Condition",
            "Condition: %s.",
            fmt(condition.value or condition.raw, 0)
        )
    end

    -- TWO-HANDED
    local twoHand = statMap["twoHanded"]
    if (twoHand and (twoHand.value == true or twoHand.raw == true)) or (item and item.isTwoHandWeapon and item:isTwoHandWeapon()) then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Melee_Stat_TwoHanded",
                "Requires both hands to wield effectively.")
        )
    end

    -- WEIGHT
    local weight = statMap["weight"]
    if weight then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Melee_Stat_Weight",
            "Weighs approximately %s units.",
            fmt(weight.value or weight.raw, 2)
        )
    end


    --------------------------------------------------------
    -- 3) PLUGIN SUPPORT
    --------------------------------------------------------
    local extra = InspectPlugins.appendMeleeLines
        and InspectPlugins.appendMeleeLines(item, statMap, subtype, parent)

    if extra then
        if type(extra) == "string" then
            InspectDescription.addLine(b, extra)
        elseif type(extra) == "table" then
            for _, line in ipairs(extra) do
                InspectDescription.addLine(b, line)
            end
        end
    end


    --------------------------------------------------------
    -- 4) FINISH
    --------------------------------------------------------
    return InspectDescription.finish(b)
end

return M
