local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    local b = InspectDescription.newBuilder()
    local matched = false

    local function addStats()
        local function fmt(n, d) return InspectUI_fmtNumber(n, d or 1) end

        local pain = statMap["reducePain"]
        if pain then
            InspectDescription.addFormatted(
                b, "IGUI_Inspect_Med_Stat_PainReduction", "Pain reduction: %s%%.",
                fmt(pain.value or pain.raw, 0))
        end

        local infect = statMap["reduceInfection"]
        if infect then
            InspectDescription.addFormatted(
                b, "IGUI_Inspect_Med_Stat_InfectionReduction", "Infection reduction: %s%%.",
                fmt(infect.value or infect.raw, 0))
        end

        local heal = statMap["healingAmount"]
        if heal then
            InspectDescription.addFormatted(
                b, "IGUI_Inspect_Med_Stat_Healing", "Healing strength: %s.",
                fmt(heal.value or heal.raw, 1))
        end

        local calm = statMap["calmingEffect"]
        if calm then
            InspectDescription.addFormatted(
                b, "IGUI_Inspect_Med_Stat_Calming", "Calming effect: %s.",
                fmt(calm.value or calm.raw, 1))
        end

        local purify = statMap["purificationPower"]
        if purify then
            InspectDescription.addFormatted(
                b, "IGUI_Inspect_Med_Stat_Purification", "Purification strength: %s.",
                fmt(purify.value or purify.raw, 1))
        end

        local uses = statMap["usesLeft"]
        if uses then
            InspectDescription.addFormatted(
                b, "IGUI_Inspect_Med_Stat_Uses", "Remaining uses: %s.",
                fmt(uses.value or uses.raw, 0))
        end

        local w = statMap["weight"]
        if w then
            InspectDescription.addFormatted(
                b, "IGUI_Inspect_Med_Stat_Weight", "Weight: %s units.",
                fmt(w.value or w.raw, 2))
        end

        local cond = statMap["condition"]
        if cond then
            InspectDescription.addFormatted(
                b, "IGUI_Inspect_Med_Stat_Condition", "Condition: %s%%.",
                fmt(cond.value or cond.raw, 0))
        end
    end

    --------------------------------------------------------
    -- SUBTYPE: BANDAGE
    --------------------------------------------------------
    if child == "Bandage" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Bandage_Base",
                "Sterile material used to cover wounds, protect tissue and promote healing.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Bandage_Usage",
                "Applied to control bleeding, reduce contamination and stabilize injuries.")
        )
        matched = true
    elseif child == "Disinfectant" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Disinfectant_Base",
                "Chemical or alcohol-based solution used to eliminate bacteria and prevent infection.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Disinfectant_Usage",
                "Applied directly on wounds or used to sterilize medical equipment.")
        )
        matched = true
    elseif child == "Painkiller" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Painkiller_Base",
                "Medication intended to reduce pain and inflammation in mild to moderate injuries.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Painkiller_Usage",
                "Provides temporary symptom relief but does not treat underlying conditions.")
        )
        matched = true
    elseif child == "Antibiotic" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Antibiotic_Base",
                "Medication used to combat bacterial infections and reduce microbial growth.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Antibiotic_Usage",
                "Most effective when applied early to prevent infection spread.")
        )
        matched = true
    elseif child == "Sedative" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Sedative_Base",
                "Sedative or calming agent used to reduce stress, panic or induce sleep.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Sedative_Usage",
                "May affect alertness or coordination; recommended for controlled situations.")
        )
        matched = true
    elseif child == "Purifier" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Purifier_Base",
                "Chemical treatment used to neutralize contaminants or toxins in water or body.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Purifier_Usage",
                "Commonly used to sanitize water or treat early ingestion symptoms.")
        )
        matched = true
    elseif child == "Herbal" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Herbal_Base",
                "Natural medicinal plant or extract with mild therapeutic properties.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Herbal_Usage",
                "Used for minor treatments, alternative care or symptom reduction.")
        )
        matched = true
    elseif child == "MedicalTool" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Tool_Base",
                "Medical tool used for examination, wound treatment or surgical assistance.")
        )

        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Tool_Usage",
                "Required for precise procedures or the application of certain treatments.")
        )
        matched = true
    end


    --------------------------------------------------------
    -- FALLBACK
    --------------------------------------------------------
    if not matched then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Med_Fallback",
                "Medical item with therapeutic or supportive health functionality.")
        )
    end


    --------------------------------------------------------
    -- STATS
    --------------------------------------------------------
    addStats()


    --------------------------------------------------------
    -- PLUGINS
    --------------------------------------------------------
    local extra =
        InspectPlugins.appendMedicalLines and
        InspectPlugins.appendMedicalLines(item, statMap, child, parent)

    if extra then
        if type(extra) == "string" then
            InspectDescription.addLine(b, extra)
        else
            for _, line in ipairs(extra) do
                InspectDescription.addLine(b, line)
            end
        end
    end

    return InspectDescription.finish(b)
end

return M
